

Program TVD_SOLVER
!-------------------------------------------------------
!    This is the main program
!    Last Update: 10/20/2010 Fengyan Shi, University of Delaware
!
!    MAIN - READ_INPUT
!         - INDEX
!         - ALLOCATE_VARIABLES
!         - INITIALIZATION 
!         DO LOOP
!             - VARIABLE_UPDATING
!             - EXCHANGE
!             - ESTIMATE_DT
!                PRE/COR                 LUNGE-KUTTA
!                                      -DISPERSION
!             - FLUXES                 -FLUXES
!             - SourceTerms            -SourceTerms
!             - PREDICTOR              -ESTIMATE_HUV
!             - EXCHANGE               -EXCHANGE
!             - FLUXES                 
!             - SourceTerms again
!             - CORRECTOR
!
!             - STATISTICS
!             - PREVIEW
!          ENDDO LOOP
!-----------------------------------------------------------------
! ** OPEN FILES **
!  (1): read input, (2): output, (3): log, (4): !write/read hotstart
!-----------------------------------------------------------------
! ** HOT START DATA **
!   NOTE: read input.txt first, if HOT_START, then read  
        ! -- dimension
! Mloc,Nloc,Mloc1,Nloc1
! Nghost
! Ibeg,Iend,Jbeg,Jend,Iend1,Jend1
!   NOTE: need to confirm if the saved data is consistent with input.txt
        ! -- time
! TIME
! TOTAL_TIME
! PLOT_INTV
! PLOT_COUNT
! SCREEN_INTV
! SCREEN_COUNT
! HOTSTART_INTV
! ICOUNT
        ! spacing
! DX,DY
        ! -- physics
! DISPERSION
! Gamma1
! a1,a2,b1,b2
! SWE_ETA_DEP
        ! -- numerics
! Time_Scheme
! HIGH_ORDER
! CONSTR
! CFL
! FroudeCap
! DISP_TIME_LEFT
        ! -- wet-dry
! MinDepth,MinDepthfrc

        ! -- depth
! DEPTH
! DEPTHx
! DEPTHy
        ! variables
! U
! V
! if (.NOT.DISP_TIME_LEFT)THEN
! U0
! V0
! endif
! Ubar
! Vbar
! ETA 
! H
! MASK
! MASK9
! MAST_STRUC
!
       ! -- wavemaker
! if (WAVEMAKER is WK_IRR)
! turns out the data for Cm Sm too large, calculate it when hotstart
!
! if (WAVEMAKER is WK_REG)
! D_gen
! Beta_gen
! rlamda
! 
!
! ----------------------------------------------------------------
     USE GLOBAL
     IMPLICIT NONE

     INTEGER::ISTAGE





     CALL READ_INPUT

     CALL INDEX

! allocate variables
     CALL ALLOCATE_VARIABLES

     IF(HOT_START)THEN



     CALL READ_HOTSTART_DATA
     CALL INITIAL_HOTSTART

     ELSE
     CALL INITIALIZATION
     ENDIF





! time integration

   DO WHILE (TIME<TOTAL_TIME)







     IF(WaveMaker(1:7)=='LEF_SOL')THEN
       CALL SOLITARY_WAVE_LEFT_BOUNDARY
     ENDIF  


! update three variables
     Eta0=Eta
     Ubar0=Ubar
     Vbar0=Vbar  

     CALL UPDATE_MASK

     CALL EXCHANGE

! as Jeff pointed out there's a drop off when using onewaycoupling, it is caused by
! updates in exchange  








     CALL ESTIMATE_DT(Mloc,Nloc,DX,DY,U,V,H,MinDepthFrc,DT,CFL,TIME)

       IF(Time_Scheme(1:3)=='Pre')THEN
! 2nd-order predictor/corrector
 
       ! Source Terms







       CALL SourceTerms

      constr(1:3)='NON'
       CALL FLUXES
! predictor
     CALL PREDICTOR

     CALL EXCHANGE







     CALL SourceTerms
     
     constr(1:3)='HLL'
     CALL FLUXES

     CALL CORRECTOR

! end predictor/corrector
      ENDIF

!  Runge-Kutta Scheme 
    IF (TIME_SCHEME(1:3)=='Run')THEN
     ! 3-ORDER RUNGE-KUTTA TIME STEPPING
     DO ISTAGE=1,3


       IF(DISPERSION)THEN
         CALL Cal_Dispersion
       ENDIF


       CALL FLUXES


       CALL SourceTerms   ! put sourceterms after fluxes in order to get eta_t

       CALL ESTIMATE_HUV(ISTAGE)      

       CALL EXCHANGE



       IF(SPONGE_ON)THEN
         CALL SPONGE_DAMPING
       ENDIF

     ENDDO
    ENDIF
!   end Runge-Kutta Scheme


      DO J=1,Nloc
      DO I=1,Mloc
        IF(MASK(I,J).GT.0)THEN
        IF(Eta(I,J).GT.HeightMax(I,J)) HeightMax(I,J)=Eta(I,J)
        ENDIF
      ENDDO
      ENDDO


     SCREEN_COUNT=SCREEN_COUNT+DT

     IF(SCREEN_COUNT>=SCREEN_INTV)THEN
      SCREEN_COUNT=SCREEN_COUNT-SCREEN_INTV
      CALL STATISTICS
     ENDIF


! show breaking

      IF(SHOW_BREAKING)THEN
        CALL BREAKING(Mloc,Nloc,ETAx,ETAy,ETAT,Cbrk1,Cbrk2,H,MinDepthFrc,DT,&
               DX,DY,T_brk,AGE_BREAKING)
      ENDIF

! stations
      IF(NumberStations>0)THEN
      PLOT_COUNT_STATION=PLOT_COUNT_STATION+DT
      IF(PLOT_COUNT_STATION>=PLOT_INTV_STATION)THEN
       PLOT_COUNT_STATION=PLOT_COUNT_STATION-PLOT_INTV_STATION
       CALL STATIONS
      ENDIF
      ENDIF
! preview
      PLOT_COUNT=PLOT_COUNT+DT
      IF(PLOT_COUNT>=PLOT_INTV)THEN
       PLOT_COUNT=PLOT_COUNT-PLOT_INTV
       CALL PREVIEW
      ENDIF
! !write out hot start data
      HOTSTART_COUNT=HOTSTART_COUNT+DT
      IF(HOTSTART_COUNT>=HOTSTART_INTV)THEN
       HOTSTART_COUNT=HOTSTART_COUNT-HOTSTART_INTV
       CALL WRITE_HOTSTART_DATA
      ENDIF
  
   END DO

     WRITE(*,*)'Normal Termination!'
     WRITE(3,*)'Normal Termination!'


END PROGRAM TVD_SOLVER



! --------------------------------------------------
!    This is subroutine to show wave breaking 
!    breaking is actually automatically calculated using
!    shock wave capturing scheme, this subroutine is only for
!    demonstration or calculating bubbles or foam 
!    called by
!       MAIN
!    
!    Last Update: 11/22/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------

SUBROUTINE BREAKING(M,N,ETAx,ETAy,ETAT,Cbrk1,Cbrk2,H,MinDepthFrc,&
               DT,DX,DY,T_brk,AGE)
     USE PARAM
     IMPLICIT NONE
     INTEGER,INTENT(IN)::M,N
     REAL(SP),INTENT(IN)::Cbrk1,Cbrk2,MinDepthFrc,DT,T_brk
     REAL(SP),DIMENSION(M,N),INTENT(IN)::DX,DY
     REAL(SP),DIMENSION(M,N),INTENT(IN)::ETAx,ETAy,ETAt,H
     REAL(SP),DIMENSION(M,N),INTENT(OUT)::AGE
     REAL(SP)::C,Angle,AGE1,AGE2,AGE3,propx,propy,propxy

     DO J=1,N
     DO I=1,M

     tmp3=SQRT(GRAV*MAX(MinDepthFrc,H(I,J)))
     tmp1=Cbrk1*tmp3
     IF(ETAt(I,J).GE.tmp1.AND.(  &
       AGE(I,J).EQ.ZERO.OR.AGE(I,J).GT.T_brk))THEN
      AGE(I,J)=DT
     ELSE
      IF(AGE(I,J).GT.ZERO)THEN
        AGE(I,J)=AGE(I,J)+DT
      ELSE
        tmp1=MAX(SQRT(ETAx(I,J)*ETAx(I,J)+ETAy(I,J)*ETAy(I,J)),SMALL)
        C=MIN(ABS(ETAt(I,J))/tmp1,SQRT(GRAV*ABS(H(I,J))))
! propagation time between a dx, dy and ds
        propxy=SQRT(DX(I,J)*DX(I,J)+DY(I,J)*DY(I,J))/MAX(C,SMALL)
        propx=SQRT(DX(I,J)*DX(I,J))/MAX(C,SMALL)
        propy=SQRT(DY(I,J)*DY(I,J))/MAX(C,SMALL)
        ANGLE=ATAN2(ETAy(I,J),ETAx(I,J))
        tmp2=Cbrk2*tmp3

        IF(ETAt(I,J).GE.tmp2)THEN
! 4 quadrants 
! quadrant 1
         IF(ANGLE.GE.ZERO.AND.ANGLE.LT.90.0_SP)THEN
           AGE1=AGE(I-1,J)
           AGE2=AGE(I-1,J-1)
           AGE3=AGE(I,J-1)
           IF((AGE1>=DT.AND.AGE1>propx).OR.&
              (AGE2>=DT.AND.AGE2>propxy).OR.&
              (AGE3>=DT.AND.AGE3>propy))THEN
            AGE(I,J)=DT
           ENDIF         
         ENDIF
! quadrant 2
         IF(ANGLE.GE.90.0_SP.AND.ANGLE.LT.180.0_SP)THEN
           AGE1=AGE(I+1,J)
           AGE2=AGE(I+1,J-1)
           AGE3=AGE(I,J-1)
           IF((AGE1>=DT.AND.AGE1>propx).OR.&
              (AGE2>=DT.AND.AGE2>propxy).OR.&
              (AGE3>=DT.AND.AGE3>propy))THEN
            AGE(I,J)=DT
           ENDIF         
         ENDIF
! quadrant 3
         IF(ANGLE.GE.-180.0_SP.AND.ANGLE.LT.-90.0_SP)THEN
           AGE1=AGE(I+1,J)
           AGE2=AGE(I+1,J+1)
           AGE3=AGE(I,J+1)
           IF((AGE1>=DT.AND.AGE1>propx).OR.&
              (AGE2>=DT.AND.AGE2>propxy).OR.&
              (AGE3>=DT.AND.AGE3>propy))THEN
            AGE(I,J)=DT
           ENDIF         
         ENDIF
! quadrant 4
         IF(ANGLE.GE.-90.0_SP.AND.ANGLE.LT.0.0_SP)THEN
           AGE1=AGE(I,J+1)
           AGE2=AGE(I-1,J+1)
           AGE3=AGE(I-1,J)
           IF((AGE1>=DT.AND.AGE1>propy).OR.&
              (AGE2>=DT.AND.AGE2>propxy).OR.&
              (AGE3>=DT.AND.AGE3>propx))THEN
            AGE(I,J)=DT
           ENDIF         
         ENDIF

       ENDIF

      ENDIF
     ENDIF 
     ENDDO
     ENDDO

END SUBROUTINE BREAKING
! --------------------------------------------------
!    This is subroutine to damp waves using DHI type sponge layer 
!    variables
!    called by
!       MAIN
!    
!    Last Update: 10/27/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE SPONGE_DAMPING
     USE GLOBAL
     IMPLICIT NONE

     DO J=1,Nloc
     DO I=1,Mloc
      IF(MASK(I,J)>ZERO)THEN
       ETA(I,J)=ETA(I,J)/SPONGE(I,J)
      ENDIF
       U(I,J)=U(I,J)/SPONGE(I,J)
       V(I,J)=V(I,J)/SPONGE(I,J)
     ENDDO
     ENDDO

END SUBROUTINE SPONGE_DAMPING

! --------------------------------------------------
!    This is subroutine to calculation dispersion terms
!    so far V^4 and V^1
!    called by
!       MAIN
!    call DERIVATIVE_XX
!         DERIVATIVE_XY
!    
!    Last Update: 09/24/2011 Fengyan Shi, University of Delaware
!    Fengyan Shi change derivative_xx_high to second order
!    according to Harris' suggestion
! --------------------------------------------------
SUBROUTINE CAL_DISPERSION
     USE GLOBAL
     IMPLICIT NONE

     REAL(SP),Dimension(Mloc,Nloc) :: DU,DV,DUt,DVt
     REAL(SP) :: UxxVxy,UxyVyy,HUxxHVxy,HUxyHVyy, &
                 UxxVxy_x,UxxVxy_y,UxyVyy_x,UxyVyy_y, &
                 HUxxHVxy_x,HUxxHVxy_y,HUxyHVyy_x,HUxyHVyy_y, &
                 rh,rhx,rhy,reta,ken1,ken2,ken3,ken4,ken5
! uxx
    CALL DERIVATIVE_XX(Mloc,Nloc,Ibeg,Iend,Jbeg,Jend,MASK9,DX,U,Uxx)
! uxy
    CALL DERIVATIVE_XY(Mloc,Nloc,Ibeg,Iend,Jbeg,Jend,MASK9,DX,DY,U,Uxy)
! vxy
    CALL DERIVATIVE_XY(Mloc,Nloc,Ibeg,Iend,Jbeg,Jend,MASK9,DX,DY,V,Vxy)
! vyy
    CALL DERIVATIVE_YY(Mloc,Nloc,Ibeg,Iend,Jbeg,Jend,MASK9,DY,V,Vyy)

    IF(SHOW_BREAKING)THEN
     CALL DERIVATIVE_X(Mloc,Nloc,Ibeg,Iend,Jbeg,Jend,MASK9,DX,Eta,ETAx)
     CALL DERIVATIVE_Y(Mloc,Nloc,Ibeg,Iend,Jbeg,Jend,MASK9,DY,Eta,ETAy)
    ENDIF

! DU DV
     DO J=1,Nloc
     DO I=1,Mloc
       DU(I,J)=Max(Depth(I,J),MinDepthFrc)*U(I,J)
       DV(I,J)=Max(Depth(I,J),MinDepthFrc)*V(I,J)
     ENDDO
     ENDDO 
! ETAT
    IF(SHOW_BREAKING)THEN
       DO J=1,Nloc
       DO I=1,Mloc
         ETAT(I,J)=-(P(I+1,J)-P(I,J))/DX(I,J)-(Q(I,J+1)-Q(I,J))/DY(I,J)
       ENDDO
       ENDDO
    ENDIF

! DUxx
    CALL DERIVATIVE_XX(Mloc,Nloc,Ibeg,Iend,Jbeg,Jend,MASK9,DX,DU,DUxx)
! DUxy
    CALL DERIVATIVE_XY(Mloc,Nloc,Ibeg,Iend,Jbeg,Jend,MASK9,DX,DY,DU,DUxy)
! DVxy
    CALL DERIVATIVE_XY(Mloc,Nloc,Ibeg,Iend,Jbeg,Jend,MASK9,DX,DY,DV,DVxy)
! DVyy
    CALL DERIVATIVE_YY(Mloc,Nloc,Ibeg,Iend,Jbeg,Jend,MASK9,DY,DV,DVyy)


! this may affect parallel version

!  boundary conditions
     DO J=1,Nloc
       Uxy(Ibeg,J)=ZERO
       DUxy(Ibeg,J)=ZERO
       Vxy(Ibeg,J)=ZERO
       DVxy(Ibeg,J)=ZERO
      IF(DISP_TIME_LEFT)THEN
      ELSE
       Utxy(Ibeg,J)=ZERO
       DUtxy(Ibeg,J)=ZERO
       Vtxy(Ibeg,J)=ZERO
       DVtxy(Ibeg,J)=ZERO
      ENDIF
     ENDDO  

     DO J=1,Nloc
       Uxy(Iend,J)=ZERO
       DUxy(Iend,J)=ZERO
       Vxy(Iend,J)=ZERO
       DVxy(Iend,J)=ZERO
      IF(DISP_TIME_LEFT)THEN
      ELSE
       Utxy(Iend,J)=ZERO
       DUtxy(Iend,J)=ZERO
       Vtxy(Iend,J)=ZERO
       DVtxy(Iend,J)=ZERO
      ENDIF
     ENDDO 

     DO I=1,Mloc
       Uxy(I,Jbeg)=ZERO
       DUxy(I,Jbeg)=ZERO
       Vxy(I,Jbeg)=ZERO
       DVxy(I,Jbeg)=ZERO

      IF(DISP_TIME_LEFT)THEN
      ELSE
       Utxy(I,Jbeg)=ZERO
       DUtxy(I,Jbeg)=ZERO
       Vtxy(I,Jbeg)=ZERO
       DVtxy(I,Jbeg)=ZERO
      ENDIF
     ENDDO   

     DO I=1,Mloc
       Uxy(I,Jend)=ZERO
       DUxy(I,Jend)=ZERO
       Vxy(I,Jend)=ZERO
       DVxy(I,Jend)=ZERO
      IF(DISP_TIME_LEFT)THEN
      ELSE
       Utxy(I,Jend)=ZERO
       DUtxy(I,Jend)=ZERO
       Vtxy(I,Jend)=ZERO
       DVtxy(I,Jend)=ZERO
      ENDIF
     ENDDO 

    CALL EXCHANGE_DISPERSION
     
! calculate V1p  without nonlinear dispersion
     DO J=1,Nloc
     DO I=1,Mloc
       U1p(I,J)=0.5_SP*(1.0_SP-Beta_1)*DEPTH(I,J)*DEPTH(I,J)*(Uxx(I,J)+Vxy(I,J)) &
               +(Beta_1-1.0_SP)*DEPTH(I,J)*(DUxx(I,J)+DVxy(I,J))
       V1p(I,J)=0.5_SP*(1.0_SP-Beta_1)*DEPTH(I,J)*DEPTH(I,J)*(Uxy(I,J)+Vyy(I,J)) &
               +(Beta_1-1.0_SP)*DEPTH(I,J)*(DUxy(I,J)+DVyy(I,J))
     ENDDO
     ENDDO


END SUBROUTINE CAL_DISPERSION

! --------------------------------------------------
!    This is subroutine to calculation first-derivative y with higher-order
!    called by
!       CAL_DISPERSION
!    Last Update: 10/11/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE DERIVATIVE_Y_High(M,N,Ibeg,Iend,Jbeg,Jend,MASK,DY,Uin,Uout)
     USE PARAM
     IMPLICIT NONE
     INTEGER,INTENT(IN) :: M,N,Ibeg,Iend,Jbeg,Jend
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: Uin
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: DY
     INTEGER,DIMENSION(M,N),INTENT(IN) :: MASK
     REAL(SP),DIMENSION(M,N),INTENT(OUT) :: Uout

     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
       Uout(I,J)= (Uin(I,J+2)+2.0_SP*Uin(I,J+1)    &
                 -Uin(I,J-2)-2.0_SP*Uin(I,J-1))/DY(I,J)/8.0_SP*MASK(I,J)
     ENDDO
     ENDDO

END SUBROUTINE DERIVATIVE_Y_High

! --------------------------------------------------
!    This is subroutine to calculation first-derivative x with higher-order
!    called by
!       CAL_DISPERSION
!    Last Update: 10/11/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE DERIVATIVE_X_High(M,N,Ibeg,Iend,Jbeg,Jend,MASK,DX,Uin,Uout)
     USE PARAM
     IMPLICIT NONE
     INTEGER,INTENT(IN) :: M,N,Ibeg,Iend,Jbeg,Jend
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: Uin
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: DX
     INTEGER,DIMENSION(M,N),INTENT(IN) :: MASK
     REAL(SP),DIMENSION(M,N),INTENT(OUT) :: Uout

     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
       Uout(I,J)= (Uin(I+2,J)+2.0_SP*Uin(I+1,J)    &
                 -Uin(I-2,J)-2.0_SP*Uin(I-1,J))/DX(I,J)/8.0_SP*MASK(I,J)
     ENDDO
     ENDDO

END SUBROUTINE DERIVATIVE_X_High

! --------------------------------------------------
!    This is subroutine to calculation first-derivative y
!    called by
!       CAL_DISPERSION
!    Last Update: 10/11/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE DERIVATIVE_Y(M,N,Ibeg,Iend,Jbeg,Jend,MASK,DY,Uin,Uout)
     USE PARAM
     IMPLICIT NONE
     INTEGER,INTENT(IN) :: M,N,Ibeg,Iend,Jbeg,Jend
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: Uin
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: DY
     INTEGER,DIMENSION(M,N),INTENT(IN) :: MASK
     REAL(SP),DIMENSION(M,N),INTENT(OUT) :: Uout

     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
       Uout(I,J)= (Uin(I,J+1)   &
                 -Uin(I,J-1))/DY(I,J)/2.0_SP*MASK(I,J)
     ENDDO
     ENDDO

END SUBROUTINE DERIVATIVE_Y

! --------------------------------------------------
!    This is subroutine to calculation first-derivative x
!    called by
!       CAL_DISPERSION
!    Last Update: 10/11/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE DERIVATIVE_X(M,N,Ibeg,Iend,Jbeg,Jend,MASK,DX,Uin,Uout)
     USE PARAM
     IMPLICIT NONE
     INTEGER,INTENT(IN) :: M,N,Ibeg,Iend,Jbeg,Jend
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: Uin
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: DX
     INTEGER,DIMENSION(M,N),INTENT(IN) :: MASK
     REAL(SP),DIMENSION(M,N),INTENT(OUT) :: Uout

     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
       Uout(I,J)= (Uin(I+1,J)    &
                 -Uin(I-1,J))/DX(I,J)/2.0_SP*MASK(I,J)
     ENDDO
     ENDDO

END SUBROUTINE DERIVATIVE_X

! --------------------------------------------------
!    This is subroutine to calculation 2nd-derivative yy
!    called by
!       CAL_DISPERSION
!    Last Update: 09/21/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE DERIVATIVE_YY(M,N,Ibeg,Iend,Jbeg,Jend,MASK,DY,Uin,Uout)
     USE PARAM
     IMPLICIT NONE
     INTEGER,INTENT(IN) :: M,N,Ibeg,Iend,Jbeg,Jend
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: Uin
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: DY
     INTEGER,DIMENSION(M,N),INTENT(IN) :: MASK
     REAL(SP),DIMENSION(M,N),INTENT(OUT) :: Uout

! I assume no 2nd derivative 
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
       Uout(I,J)= (Uin(I,J+1)-2.0_SP*Uin(I,J) & 
                 +Uin(I,J-1))/DY(I,J)/DY(I,J)*MASK(I,J)
     ENDDO
     ENDDO

END SUBROUTINE DERIVATIVE_YY

! --------------------------------------------------
!    This is subroutine to calculation 2nd-derivative xy
!    called by
!       CAL_DISPERSION
!    Last Update: 09/21/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE DERIVATIVE_XY(M,N,Ibeg,Iend,Jbeg,Jend,MASK,DX,DY,Uin,Uout)
     USE PARAM
     IMPLICIT NONE
     INTEGER,INTENT(IN) :: M,N,Ibeg,Iend,Jbeg,Jend
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: Uin
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: DX,DY
     INTEGER,DIMENSION(M,N),INTENT(IN) :: MASK
     REAL(SP),DIMENSION(M,N),INTENT(OUT) :: Uout

     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
       tmp1=(Uin(I+1,J+1)-Uin(I+1,J-1))/2.0_SP/DY(I,J)
       tmp2=(Uin(I-1,J+1)-Uin(I-1,J-1))/2.0_SP/DY(I,J)
       Uout(I,J)= (tmp1-tmp2)/2.0_SP/DX(I,J)*MASK(I,J)
     ENDDO
     ENDDO

END SUBROUTINE DERIVATIVE_XY

! --------------------------------------------------
!    This is subroutine to calculation 2nd-derivative xx
!    called by
!       CAL_DISPERSION
!    Last Update: 09/21/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE DERIVATIVE_XX(M,N,Ibeg,Iend,Jbeg,Jend,MASK,DX,Uin,Uout)
     USE PARAM
     IMPLICIT NONE
     INTEGER,INTENT(IN) :: M,N,Ibeg,Iend,Jbeg,Jend
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: Uin
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: DX
     INTEGER,DIMENSION(M,N),INTENT(IN) :: MASK
     REAL(SP),DIMENSION(M,N),INTENT(OUT) :: Uout

! I assume no 2nd derivative 
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
       Uout(I,J)= (Uin(I+1,J)-2.0_SP*Uin(I,J) & 
                 +Uin(I-1,J))/DX(I,J)/DX(I,J)*MASK(I,J)
     ENDDO
     ENDDO

END SUBROUTINE DERIVATIVE_XX

! $$$
! --------------------------------------------------
!    This is subroutine to calculation 4th-derivative xy
!    called by
!       CAL_DISPERSION
!    Last Update: 09/21/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE DERIVATIVE_XY_HIGH(M,N,Ibeg,Iend,Jbeg,Jend,MASK,DX,DY,Uin,Uout)
     USE PARAM
     IMPLICIT NONE
     INTEGER,INTENT(IN) :: M,N,Ibeg,Iend,Jbeg,Jend
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: Uin
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: DX,DY
     INTEGER,DIMENSION(M,N),INTENT(IN) :: MASK
     REAL(SP),DIMENSION(M,N),INTENT(OUT) :: Uout

     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
! to assure symmetric, use locally constant dx and dy
       tmp1=1.0_SP/12.0_SP/DY(I,J)*(Uin(I-2,J-2)-8.0_SP*Uin(I-2,J-1) &
                             +8.0_SP*Uin(I-2,J+1)-Uin(I-2,J+2))
       tmp2=1.0_SP/12.0_SP/DY(I,J)*(Uin(I-1,J-2)-8.0_SP*Uin(I-1,J-1) &
                             +8.0_SP*Uin(I-1,J+1)-Uin(I-1,J+2))
       tmp3=1.0_SP/12.0_SP/DY(I,J)*(Uin(I+1,J-2)-8.0_SP*Uin(I+1,J-1) &
                             +8.0_SP*Uin(I+1,J+1)-Uin(I+1,J+2))
       tmp4=1.0_SP/12.0_SP/DY(I,J)*(Uin(I+2,J-2)-8.0_SP*Uin(I+2,J-1) &
                             +8.0_SP*Uin(I+2,J+1)-Uin(I+2,J+2))
       Uout(I,J)=MASK(I,J)/12.0_SP/DX(I,J)*(tmp1-8.0_SP*tmp2 &
                             +8.0_SP*tmp3-tmp4)
     ENDDO
     ENDDO

END SUBROUTINE DERIVATIVE_XY_HIGH
! --------------------------------------------------
!    This is subroutine to calculation 4th-derivative xx
!    called by
!       CAL_DISPERSION
!    Last Update: 05/30/2011 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE DERIVATIVE_XX_HIGH(M,N,Ibeg,Iend,Jbeg,Jend,MASK,DX,Uin,Uout)
     USE PARAM
     IMPLICIT NONE
     INTEGER,INTENT(IN) :: M,N,Ibeg,Iend,Jbeg,Jend
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: Uin
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: DX
     INTEGER,DIMENSION(M,N),INTENT(IN) :: MASK
     REAL(SP),DIMENSION(M,N),INTENT(OUT) :: Uout

! I assume no 2nd derivative 
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
       Uout(I,J) = MASK(I,J)*1.0_SP/12.0_SP/DX(I,J)/DX(I,J)*(-Uin(I-2,J)+16.0_SP*Uin(I-1,J)   &
                -30.0_SP*Uin(I,J)+16.0_SP*Uin(I+1,J)-Uin(I+2,J))
     ENDDO
     ENDDO

END SUBROUTINE DERIVATIVE_XX_HIGH
! --------------------------------------------------
!    This is subroutine to calculation 4th-derivative yy
!    called by
!       CAL_DISPERSION
!    Last Update: 05/30/2011 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE DERIVATIVE_YY_HIGH(M,N,Ibeg,Iend,Jbeg,Jend,MASK,DY,Uin,Uout)
     USE PARAM
     IMPLICIT NONE
     INTEGER,INTENT(IN) :: M,N,Ibeg,Iend,Jbeg,Jend
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: Uin
     REAL(SP),DIMENSION(M,N),INTENT(IN) :: DY
     INTEGER,DIMENSION(M,N),INTENT(IN) :: MASK
     REAL(SP),DIMENSION(M,N),INTENT(OUT) :: Uout

! I assume no 2nd derivative 
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
       Uout(I,J) = MASK(I,J)*1.0_SP/12.0_SP/DY(I,J)/DY(I,J)*(-Uin(I,J-2)+16.0_SP*Uin(I,J-1)   &
                -30.0_SP*Uin(I,J)+16.0_SP*Uin(I,J+1)-Uin(I+2,J+2))
     ENDDO
     ENDDO

END SUBROUTINE DERIVATIVE_YY_HIGH

! $$$

! --------------------------------------------------
!    This is subroutine to update mask
!    note that mask also be updated in fluxes routine
!    called by
!         MAIN
!    Last Update: 05/28/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE UPDATE_MASK
     USE GLOBAL
     IMPLICIT NONE
     REAL(SP)::left,right,top,bottom

! for the serial code, MASK at ghost cells keep no change


! Jeff did the following loop, also work for serial
!     DO J=Jbeg,Jend
!     DO I=Ibeg,Iend

     DO J=Jbeg-2,Jend+2
     DO I=Ibeg-2,Iend+2
! flood
     IF(MASK_STRUC(I,J)==1)THEN
       IF(MASK(I,J)<1)THEN
         ! left
        IF(I/=1)THEN
         IF(MASK(I-1,J)==1.AND.Eta(I-1,J)>Eta(I,j))THEN
           MASK(I,J)=1
         ENDIF
        ENDIF
         ! right
        IF(I/=Mloc)THEN
         IF(MASK(I+1,J)==1.AND.Eta(I+1,J)>Eta(I,j))THEN
           MASK(I,J)=1
         ENDIF
        ENDIF
         ! bottom
        IF(J/=1)THEN
         IF(MASK(I,J-1)==1.AND.Eta(I,J-1)>Eta(I,j))THEN
           MASK(I,J)=1
         ENDIF
        ENDIF
         ! top
        IF(J/=Nloc)THEN
         IF(MASK(I,J+1)==1.AND.Eta(I,J+1)>Eta(I,j))THEN
           MASK(I,J)=1
         ENDIF
        ENDIF
! drying
       ELSE
         IF(Eta(I,J)<-Depth(I,J))THEN
          MASK(I,J)=0
          Eta(I,J)=MinDepth-Depth(I,J)
         ENDIF    
       ENDIF
      ENDIF

! to avoid extreme depth gradient caused by depthx and depthy which were not
! treated in initialization, I reset depthx and depthy when drying 
! 01/21/2012

        IF(MASK(I,J)<1)THEN
         DepthX(I,J)=Depth(I-1,J)
         DepthX(I+1,J)=Depth(I+1,J)
         DepthY(I,J)=Depth(I,J-1)
         DepthY(I,J+1)=Depth(I,J+1)
        ENDIF    

     ENDDO
     ENDDO


! Jeff also did this loop
!     DO J=Jbeg,Jend
!     DO I=Ibeg,Iend
     DO J=Jbeg-1,Jend+1
     DO I=Ibeg-1,Iend+1
      MASK9(I,J)=MASK(I,J)*MASK(I-1,J)*MASK(I+1,J)  &
                *MASK(I+1,J+1)*MASK(I,J+1)*MASK(I-1,J+1) &
                *MASK(I+1,J-1)*MASK(I,J-1)*MASK(I-1,J-1) 
      IF(ABS(Eta(I,J))/MAX(DEPTH(I,J),MinDepthFrc)>SWE_ETA_DEP)THEN
       MASK9(I,J)=ZERO
      ENDIF

     ENDDO
     ENDDO
  

END SUBROUTINE UPDATE_MASK

! --------------------------------------------------
!    This is subroutine for all source terms including slope term dispersion 
!    called by
!       MAIN
!    Last Update: 05/28/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE SourceTerms
     USE GLOBAL
     IMPLICIT NONE

! depth gradient term
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend


! second order, move the second term to left-hand side
       SourceX(I,J)=GRAV*(Eta(I,J))*SlopeX(I,J)*MASK(I,J) &
                       ! friction
                   -Cd*U(I,J)*SQRT(U(I,J)*U(I,J)+V(I,J)*V(I,J)) &
                       ! dispersion
                        ! Ht(+V1p) = div(M)*(-U1p)
                    +Gamma1*MASK9(I,J)*((P(I+1,J)-P(I,J))/DX(I,J)+(Q(I,J+1)-Q(I,J))/DY(I,J)) &
                      *(-U1p(I,J)) &
                        ! Coriolis
                    +Coriolis(I,J)*0.5_SP*(Q(I,J)+Q(I,J+1))

          

       SourceY(I,J)=GRAV*(Eta(I,J))*SlopeY(I,J)*MASK(I,J) &
                          ! friction
                   -Cd*V(I,J)*SQRT(U(I,J)*U(I,J)+V(I,J)*V(I,J)) &
                          ! dispersion
                          ! Ht(+V1p) = div(Q)*(-V1p)
                    +Gamma1*MASK9(I,J)*((P(I+1,J)-P(I,J))/DX(I,J)+(Q(I,J+1)-Q(I,J))/DY(I,J)) &
                      *(-V1p(I,J)) &
                        ! Coriolis
                    -Coriolis(I,J)*0.5_SP*(P(I,J)+P(I+1,J))


     ENDDO
     ENDDO

END SUBROUTINE SourceTerms

! --------------------------------------------------
!    This is subroutine to show statistics
!    called by
!        MAIN
!    Last Update: 05/06/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE STATISTICS
     USE GLOBAL
     IMPLICIT NONE

     REAL(SP)::MassVolume=ZERO,Energy=ZERO,MaxEta=ZERO,MinEta=ZERO, &
              MaxU=ZERO,MaxV=ZERO,Fr=ZERO,UTotal=ZERO,UTotalMax=ZERO
!
     MassVolume=ZERO
     Energy=ZERO
     UTotalMax=ZERO

     DO J=Jbeg,Jend
     DO I=Ibeg,Iend

! Vol=SUM(Eta*dx*dy), reference is at z=0
! Energy=SUM(1/2*g*H^2*dx*dy+0.5*u^2*H*dx*dy)

       MassVolume=MassVolume+Eta(I,J)*DX(I,J)*DY(I,J)
       Energy=Energy+0.5_SP*H(I,J)*H(I,J)*GRAV*DX(I,J)*DY(I,J) &
             +0.5_SP*U(I,J)*U(I,J)*H(I,J)*DX(I,J)*DY(I,J) &
             +0.5_SP*V(I,J)*V(I,J)*H(I,J)*DX(I,J)*DY(I,J)
!       print*,I,J,Energy,H(I,J),U(I,J),V(I,J)       
     ENDDO
!      pause
     ENDDO
!     stop

     MaxEta=MAXVAL(Eta(Ibeg:Iend,Jbeg:Jend))
     MinEta=MINVAL(Eta(Ibeg:Iend,Jbeg:Jend))
     MaxU=MAXVAL(ABS(U(Ibeg:Iend,Jbeg:Jend)))
     MaxV=MAXVAL(ABS(V(Ibeg:Iend,Jbeg:Jend)))

! found Froude vs. max speed
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
      IF(MASK(I,J)>ZERO)THEN
       Utotal=SQRT(U(I,J)*U(I,J)+V(I,J)*V(I,J))
       IF(Utotal.gt.UtotalMax)THEN
         UtotalMax=Utotal
         Fr=SQRT(GRAV*Max(H(I,J),MinDepthfrc))
       ENDIF
      ENDIF
     ENDDO
     ENDDO
     IF(Fr==ZERO)Fr=SQRT(GRAV*MinDepthfrc)



! print screen
     WRITE(*,*),'----------------- STATISTICS ----------------'
     WRITE(*,*),' TIME        DT'
     WRITE(*,101) Time, DT
     WRITE(*,*),' MassVolume  Energy      MaxEta      MinEta      Max U       Max V '
     WRITE(*,101), MassVolume,Energy,MaxEta,MinEta,MaxU,MaxV
     WRITE(*,*),' MaxTotalU   PhaseS      Froude '
     WRITE(*,101), UTotalMax, Fr, UTotalMax/Fr
! print log file
     WRITE(3,*),'----------------- STATISTICS ----------------'
     WRITE(3,*),' TIME        DT'
     WRITE(3,101) Time, DT
     WRITE(3,*),' MassVolume  Energy      MaxEta      MinEta      Max U       Max V '
     WRITE(3,101), MassVolume,Energy,MaxEta,MinEta,MaxU,MaxV
     WRITE(3,*),' MaxTotalU   PhaseS      Froude '
     WRITE(3,101), UTotalMax, Fr, UTotalMax/Fr

101  FORMAT(6E12.4)

END SUBROUTINE STATISTICS

! ---------------------------------------------------
!    This is subroutine ESTIMATE_HUV 
!  for 3rd-order LK scheme 
!  called by
!      MAIN
!  call
!      GET_Eta_U_V_HU_HV
!    Last Update: 05/12/2011 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE ESTIMATE_HUV(ISTEP)
     USE GLOBAL
     IMPLICIT NONE
     INTEGER,INTENT(IN)::ISTEP
     REAL(SP),PARAMETER::n_left=-1.0_SP,n_right=1.0_SP,n_bottom=-1.0_SP,n_top=1.0_SP
     REAL(SP)::F_left,F_right,F_bottom,F_top,WK_Source
     REAL(SP),DIMENSION(Ibeg:Iend,Jbeg:Jend)::R1,R2,R3
! now work for spherical # if defined (CARTESIAN)
     REAL(SP)::xmk,ymk
! now work for spherical # endif
     REAL(SP)::DXg,DYg

     INTEGER::kf,kd

! MUSCL-Hancock, Zhou et al., p. 7

     DXg=DX(1,1)
     DYg=DY(1,1)

! solve eta
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
      F_left=P(I,J)
      F_right=P(I+1,J)
      F_bottom=Q(I,J)
      F_top=Q(I,J+1)
! now work for spherical # if defined (CARTESIAN)
      IF(WAVEMAKER(1:6)=='WK_IRR')THEN
            xmk=(I-Ibeg)*DXg
            ymk=(J-Jbeg)*DYg
         IF(ABS(xmk-Xc_WK)<Width_WK.AND. &
            ABS(ymk-Yc_WK)<Ywidth_WK/2.0_SP)THEN
          WK_Source=ZERO
          DO kf=1,Nfreq
           WK_Source=WK_Source+TANH(PI/(Time_ramp/FreqPeak)*TIME)*(Cm(I,J,kf) &
                       *COS(OMGN_IR(KF)*TIME) &
                       +Sm(I,J,kf)*SIN(OMGN_IR(KF)*TIME))
          ENDDO

          R1(I,J)=-1.0_SP/DXg*(F_right*n_right+F_left*n_left) &
                -1.0_SP/DYg*(F_top*n_top+F_bottom*n_bottom) &
        ! wavemaker
                +WK_Source      
         ELSE
         R1(I,J)=-1.0_SP/DXg*(F_right*n_right+F_left*n_left) &
                   -1.0_SP/DYg*(F_top*n_top+F_bottom*n_bottom)
         ENDIF
       ELSEIF(WAVEMAKER(1:6)=='WK_REG')THEN
            xmk=(I-Ibeg)*DXg
            ymk=(J-Jbeg)*DYg
         IF(ABS(xmk-Xc_WK)<Width_WK.AND. &
            ABS(ymk-Yc_WK)<Ywidth_WK/2.0_SP)THEN
          
          R1(I,J)=-1.0_SP/DXg*(F_right*n_right+F_left*n_left) &
                -1.0_SP/DYg*(F_top*n_top+F_bottom*n_bottom) &
        ! wavemaker
                +TANH(PI/(Time_ramp*Tperiod)*TIME)*D_gen &
                 *EXP(-Beta_gen*(xmk-Xc_WK)**2)&
                 *SIN(rlamda*(ymk-ZERO)-2.0_SP*PI/Tperiod*TIME)       
         ELSE
         R1(I,J)=-1.0_SP/DXg*(F_right*n_right+F_left*n_left) &
                   -1.0_SP/DYg*(F_top*n_top+F_bottom*n_bottom)
         ENDIF
       ELSEIF(WAVEMAKER(1:7)=='WK_TIME')THEN
            xmk=(I-Ibeg)*DXg
            ymk=(J-Jbeg)*DYg
         IF(ABS(xmk-Xc_WK)<Width_WK.AND. &
            ABS(ymk-Yc_WK)<Ywidth_WK/2.0_SP)THEN

           WK_Source=ZERO
           DO kf=1,NumWaveComp
             WK_Source=WK_Source &
               +TANH(PI/(Time_ramp*PeakPeriod)*TIME)*D_genS(kf) &
                 *EXP(-Beta_genS(kf)*(xmk-Xc_WK)**2)&
                 *COS(2.0_SP*PI/WAVE_COMP(kf,1)*TIME-WAVE_COMP(kf,3)) 
           ENDDO
          
          R1(I,J)=-1.0_SP/DXg*(F_right*n_right+F_left*n_left) &
                -1.0_SP/DYg*(F_top*n_top+F_bottom*n_bottom) &
                +WK_Source      
         ELSE
         R1(I,J)=-1.0_SP/DXg*(F_right*n_right+F_left*n_left) &
                   -1.0_SP/DYg*(F_top*n_top+F_bottom*n_bottom)
         ENDIF   
! *****
       ELSEIF(WAVEMAKER(1:9)=='WK_DATA2D')THEN
            xmk=(I-Ibeg)*DXg
            ymk=(J-Jbeg)*DYg
         IF(ABS(xmk-Xc_WK)<Width_WK.AND. &
            ABS(ymk-Yc_WK)<Ywidth_WK/2.0_SP)THEN

           WK_Source=ZERO
           DO kf=1,NumFreq
            DO kd=1,NumDir
             WK_Source=WK_Source &
               +TANH(PI/(Time_ramp*PeakPeriod)*TIME)*D_gen2D(kf,kd) &
                 *EXP(-Beta_gen2D(kf,kd)*(xmk-Xc_WK)**2)&
                 *SIN(rlamda2D(kf,kd)*(ymk-ZERO) &
                      -2.0_SP*PI*Freq(kf)*TIME &
                      -Phase2D(kf,kd)) 
            ENDDO
           ENDDO
          
          R1(I,J)=-1.0_SP/DXg*(F_right*n_right+F_left*n_left) &
                -1.0_SP/DYg*(F_top*n_top+F_bottom*n_bottom) &
                +WK_Source      
         ELSE
         R1(I,J)=-1.0_SP/DXg*(F_right*n_right+F_left*n_left) &
                   -1.0_SP/DYg*(F_top*n_top+F_bottom*n_bottom)
         ENDIF 
! *****    
      ELSE ! no wk_wavemaker
        R1(I,J)=-1.0_SP/DXg*(F_right*n_right+F_left*n_left) &
                   -1.0_SP/DYg*(F_top*n_top+F_bottom*n_bottom)
      ENDIF
! now work for spherical # else
! now        R1(I,J)=-1.0_SP/DX(I,J)*(F_right*n_right+F_left*n_left) &
! now                   -1.0_SP/DY(I,J)*(F_top*n_top+F_bottom*n_bottom) &
! spherical term 1/R tan theta HV
! now                  +1.0_SP/R_earth*TAN(Lat_theta(I,J))*HV(I,J)
! now work for spherical # endif
      Eta(I,J)=ALPHA(ISTEP)*Eta0(I,J)+BETA(ISTEP)*(Eta(I,J)+DT*R1(I,J))
     ENDDO
     ENDDO

! solve ubar
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
      F_left=Fx(I,J)
      F_right=Fx(I+1,J)
      F_bottom=Fy(I,J)
      F_top=Fy(I,J+1)
      R2(I,J)=-1.0_SP/DX(I,J)*(F_right*n_right+F_left*n_left) &
                       -1.0_SP/DY(I,J)*(F_top*n_top+F_bottom*n_bottom) &
                        +SourceX(I,J)
      Ubar(I,J)=ALPHA(ISTEP)*Ubar0(I,J)+BETA(ISTEP)*(Ubar(I,J)+DT*R2(I,J))
     ENDDO
     ENDDO

! solve vbar
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
      F_left=Gx(I,J)
      F_right=Gx(I+1,J)
      F_bottom=Gy(I,J)
      F_top=Gy(I,J+1)
      R3(I,J)=-1.0_SP/DX(I,J)*(F_right*n_right+F_left*n_left) &
                       -1.0_SP/DY(I,J)*(F_top*n_top+F_bottom*n_bottom) &
                       +SourceY(I,J)
      Vbar(I,J)=ALPHA(ISTEP)*Vbar0(I,J)+BETA(ISTEP)*(Vbar(I,J)+DT*R3(I,J))
     ENDDO
     ENDDO

     CALL GET_Eta_U_V_HU_HV

END SUBROUTINE ESTIMATE_HUV

! ---------------------------------------------------
!    This is subroutine to obtain Eta, u,v,hu,hv
!  called by
!      PREDICTOR
!      CORRECTOR
!      ESTIMATE_HUV (Lunge-Kutta)
!  use FroudeCap to Limit Froude<FroudeCap
!    Last Update: 09/17/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE GET_Eta_U_V_HU_HV
     USE GLOBAL
     IMPLICIT NONE
     REAL(SP)::Fr,Utotal,Utheta,dep,depl,depr,reta,retal,retar
     REAL(SP),DIMENSION(Mloc) :: Axx,Cxx,Dxx
     REAL(SP),DIMENSION(Mloc) :: U1D
     REAL(SP),DIMENSION(Nloc) :: Ayy,Cyy,Dyy
     REAL(SP),DIMENSION(Nloc) :: V1D
      INTEGER :: IM

! calculate etar, u and vetar, HU, HV
     H=Eta*Gamma3+Depth

!     DO J=Jbeg,Jend
!     DO I=Ibeg,Iend   
! if drying, don't mask it until updating in updat_mask
!       IF(H(I,J)<ZERO)THEN
!        H(I,J)=MinDepth-SMALL
!        Eta(I,J)=H(I,J)+Z(I,J)    
!         MASK(I,J)=0   
!       ENDIF     
!     ENDDO
!     ENDDO

!   tridiagonal coefficient
! x direction

! shift U and V
     U0=U
     V0=V

   IF(DISPERSION)THEN

     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
       dep=Max(Depth(I,J),MinDepthFrc)
       depl=Max(Depth(I-1,J),MinDepthFrc)
       depr=Max(Depth(I+1,J),MinDepthFrc)

       tmp1=Gamma1*MASK9(I,J)*(b1/2.0_SP/DX(I,J)/DX(I,J)*dep*dep + b2/DX(I,J)/DX(I,J)*depl*dep)
       tmp2=1.0_SP+Gamma1*MASK9(I,J)*(-b1/DX(I,J)/DX(I,J)*dep*dep-2.0_SP*b2/DX(I,J)/DX(I,J)*dep*dep)
       tmp3=Gamma1*MASK9(I,J)*(b1/2.0_SP/DX(I,J)/DX(I,J)*dep*dep + b2/DX(I,J)/DX(I,J)*dep*depr)
       tmp4=Ubar(I,J)*MASK(I,J)/Max(H(I,J),MinDepthFrc)  &
            + Gamma1*MASK9(I,J)*( -b1/2.0_SP*dep*dep*Vxy(I,J)-b2*dep*DVxy(I,J)) 
! remember to document this part for spherical version 

       IF(tmp2.NE.0.0_SP.OR.MASK(I,J).GT.0)THEN
         Axx(I)=tmp1/tmp2
         Cxx(I)=tmp3/tmp2
         Dxx(I)=tmp4/tmp2
       ELSE
         Axx(I)=ZERO
         Cxx(I)=ZERO
         Dxx(I)=ZERO
       ENDIF
     ENDDO

     CALL TRIG(Axx,Cxx,Dxx,U1D,Mloc,Ibeg,Iend)
     U(:,J)=U1D(:)
     ENDDO


! y direction
     DO I=Ibeg,Iend
     DO J=Jbeg,Jend
       dep=Max(Depth(I,J),MinDepthFrc)
       depl=Max(Depth(I,J-1),MinDepthFrc)
       depr=Max(Depth(I,J+1),MinDepthFrc)

       tmp1=Gamma1*MASK9(I,J)*(b1/2.0_SP/DY(I,J)/DY(I,J)*dep*dep + b2/DY(I,J)/DY(I,J)*depl*dep) 
       tmp2=1.0_SP+Gamma1*MASK9(I,J)*(-b1/DY(I,J)/DY(I,J)*dep*dep-2.0_SP*b2/DY(I,J)/DY(I,J)*dep*dep) 
       tmp3=Gamma1*MASK9(I,J)*(b1/2.0_SP/DY(I,J)/DY(I,J)*dep*dep + b2/DY(I,J)/DY(I,J)*dep*depr)
       tmp4=Vbar(I,J)*MASK(I,J)/Max(H(I,J),MinDepthFrc)  &
             + Gamma1*MASK9(I,J)*(-b1/2.0_SP*dep*dep*Uxy(I,J)-b2*dep*DUxy(I,J)) 
! remember to document this part for spherical version
  
       IF(tmp2.NE.0.0_SP.OR.MASK(I,J).GT.0)THEN
         Ayy(J)=tmp1/tmp2
         Cyy(J)=tmp3/tmp2
         Dyy(J)=tmp4/tmp2
       ELSE
         Ayy(J)=ZERO
         Cyy(J)=ZERO
         Dyy(J)=ZERO
       ENDIF
     ENDDO


     CALL TRIG(Ayy,Cyy,Dyy,V1D,Nloc,Jbeg,Jend)
     V(I,:)=V1D(:)

     ENDDO ! end I


   ELSE  ! if no dispersion
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend  
        U(I,J)=Ubar(I,J)/Max(H(I,J),MinDepthFrc)
        V(I,J)=Vbar(I,J)/Max(H(I,J),MinDepthFrc)
     ENDDO
     ENDDO   

   ENDIF  ! end dispersion

     DO J=Jbeg,Jend
     DO I=Ibeg,Iend   
       IF(MASK(I,J)<1)THEN
        Ubar(I,J)=ZERO
        Vbar(I,J)=ZERO
        U(I,J)=ZERO
        V(I,J)=ZERO
        HU(I,J)=ZERO
        HV(I,J)=ZERO
       ELSE
        HU(I,J)=Max(H(I,J),MinDepthFrc)*U(I,J)
        HV(I,J)=Max(H(I,J),MinDepthFrc)*V(I,J)
! apply Froude cap
        Utotal=SQRT(U(I,J)*U(I,J)+V(I,J)*V(I,J))
        Fr=SQRT(GRAV*Max(H(I,J),MinDepthFrc))
        IF(Utotal/Fr.gt.FroudeCap)THEN
          Utheta=ATAN2(V(I,J),U(I,J))
          U(I,J)=FroudeCap*Fr*COS(Utheta)
          V(I,J)=FroudeCap*Fr*SIN(Utheta)
          HU(I,J)=U(I,J)*Max(H(I,J),MinDepthFrc)
          HV(I,J)=V(I,J)*Max(H(I,J),MinDepthFrc)
        ENDIF
! end Froude cap
       ENDIF
     ENDDO
     ENDDO

END SUBROUTINE GET_Eta_U_V_HU_HV

! ---------------------------------------------------
!    This is subroutine evaluate dt
!    Last Update: 05/06/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE ESTIMATE_DT(M,N,DX,DY,U,V,H,MinDepthFrc,DT,CFL,TIME)
     USE PARAM
     IMPLICIT NONE
     INTEGER,INTENT(IN)::M,N

     REAL(SP),DIMENSION(M,N),INTENT(IN)::DX,DY
     REAL(SP),INTENT(IN),DIMENSION(M,N)::U,V,H
     REAL(SP),INTENT(IN)::CFL,MinDepthFrc
     REAL(SP),INTENT(OUT)::DT
     REAL(SP),INTENT(INOUT)::TIME

     TMP3=LARGE
     DO J=1,N
     DO I=1,M
! x direction
      TMP1=ABS(U(I,J))+SQRT(GRAV*MAX(H(I,J),MinDepthFrc))
      IF(TMP1<SMALL)THEN
       TMP2=DX(I,J)/SMALL
      ELSE
       TMP2=DX(I,J)/TMP1
      ENDIF
      IF(TMP2<TMP3)TMP3=TMP2
! y direction
      TMP1=ABS(V(I,J))+SQRT(GRAV*MAX(H(I,J),MinDepthFrc))
      IF(TMP1<SMALL)THEN
       TMP2=DY(I,J)/SMALL
      ELSE
       TMP2=DY(I,J)/TMP1
      ENDIF
      IF(TMP2<TMP3)TMP3=TMP2      
     ENDDO
     ENDDO
     DT=CFL*TMP3
! TEMP
     TIME=TIME+DT

END SUBROUTINE ESTIMATE_DT




! ---------------------------------------------------
!    This is subroutine predictor
!  call
!      - GET_Eta_U_V_HU_HV
!    Last Update: 05/06/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE PREDICTOR
     USE GLOBAL
     IMPLICIT NONE

! MUSCL-Hancock Zhou et al, p.6
! solve eta
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
       Eta(I,J)=Eta0(i,j)-DT/2.0_SP/DX(I,J)*(P(i+1,j)-P(i,j))  &
                        -DT/2.0_SP/DY(I,J)*(Q(i,j+1)-Q(i,j))  
     ENDDO
     ENDDO
! solve u
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
       Ubar(I,J)=Ubar0(i,j)-DT/2.0_SP/DX(I,J)*(Fx(i+1,j)-Fx(i,j))  &
                        -DT/2.0_SP/DY(I,J)*(Fy(i,j+1)-Fy(i,j)) &
                        +DT/2.0_SP*SourceX(I,J)
     ENDDO
     ENDDO
! solve v
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
       Vbar(I,J)=Vbar0(i,j)-DT/2.0_SP/DX(I,J)*(Gx(i+1,j)-Gx(i,j))  &
                        -DT/2.0_SP/DY(I,J)*(Gy(i,j+1)-Gy(i,j)) &
                        +DT/2.0_SP*SourceY(I,J)
     ENDDO
     ENDDO

     CALL GET_Eta_U_V_HU_HV

END SUBROUTINE PREDICTOR

! ---------------------------------------------------
!    This is subroutine corrector
!  called by
!      MAIN
!  call
!      GET_Eta_U_V_HU_HV
!    Last Update: 05/06/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE CORRECTOR
     USE GLOBAL
     IMPLICIT NONE
     REAL(SP),PARAMETER::n_left=-1.0_SP,n_right=1.0_SP,n_bottom=-1.0_SP,n_top=1.0_SP
     REAL(SP)::F_left,F_right,F_bottom,F_top

! MUSCL-Hancock, Zhou et al., p. 7

! solve eta
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
      F_left=P(I,J)
      F_right=P(I+1,J)
      F_bottom=Q(I,J)
      F_top=Q(I,J+1)
      Eta(I,J)=Eta0(I,J)-DT/DX(I,J)*(F_right*n_right+F_left*n_left) &
                             -DT/DY(I,J)*(F_top*n_top+F_bottom*n_bottom)
     ENDDO
     ENDDO

! solve ubar
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
      F_left=Fx(I,J)
      F_right=Fx(I+1,J)
      F_bottom=Fy(I,J)
      F_top=Fy(I,J+1)
      Ubar(I,J)=Ubar0(I,J)-DT/DX(I,J)*(F_right*n_right+F_left*n_left) &
                             -DT/DY(I,J)*(F_top*n_top+F_bottom*n_bottom) &
                             +DT*SourceX(I,J)
     ENDDO
     ENDDO

! solve vbar
     DO J=Jbeg,Jend
     DO I=Ibeg,Iend
      F_left=Gx(I,J)
      F_right=Gx(I+1,J)
      F_bottom=Gy(I,J)
      F_top=Gy(I,J+1)
      Vbar(I,J)=Vbar0(I,J)-DT/DX(I,J)*(F_right*n_right+F_left*n_left) &
                             -DT/DY(I,J)*(F_top*n_top+F_bottom*n_bottom) &
                             +DT*SourceY(I,J)
     ENDDO
     ENDDO

     CALL GET_Eta_U_V_HU_HV


END SUBROUTINE CORRECTOR



! ------------------------------------------------
! This part is not subroutines
!  DEFINITIONS OF VARIABLES
! 
!    Last Update: 09/07/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
!
! Depth(): still water depth at element point
! DepthNode(): still water depth at node
! DepthX(): still water depth at x-interface
! DepthY(): still water depth at y-interface
! Eta():   surface elevation
! Eta0(): Eta at previous time level
!  for dry point, Eta() = MinDepth+Z()
! MASK(): 1 - wet
!         0 - dry
! MASK_STRUC(): 0 - permanent dry point
! MASK9: mask for itself and 8 elements around
! 
! U():  depth-averaged u or u at the reference level (u_alpha) at element
! V():  depth-averaged v or v at the reference level (v_alpha) at element
! HU(): (dep+eta)*u at element
! HV(): (dep+eta)*v at element
! P(): HU + dispersion at x-interface
! Q(): HV + dispersion at y-interface
! Fx(): F at x-interface
! Fy(): F at y-interface
! Gx(): G at x-interface
! Gy(): G at y-interface
! Ubar(:,:,:): Ubar
! Vbar(:,:,:): Vbar

! dispersion
! U1p(:,:): x-component of V1p
! V1p(:,:): y-component of V1p

! 
! EtaRxL(): Eta Left value at x-interface
! EtaRxR(): Eta Right value at x-interface
! EtaRyL(): Eta Left value at y-interface
! EtaRyR(): Eta Right value at y-interface
! HxL():   total depth  Left value at x-interface
! HxR():   total depth  Right value at x-interface
! HyL():   total depth  Left value at y-interface
! HyR():   total depth  Right value at y-interface

! HUxL(): HU Left value at x-interface
! HUxR(): HU Right value at x-interface
! HUyL(): HV Left value at y-interface
! HUyR(): HV Right value at y-interface

! PL(): HU + dispersion, Left value at x-interface
! PR(): HU + dispersion, Right value at x-interface
! QL(): HV + dispersion, Left value at y-interface
! QR(): HV + dispersion, Right value at y-interface

! FxL = HUxL*UxL + 1/2*g*(EtaRxL^2 + 2*EtaRxL*Depthx)
! FxR = HUxR*UxR + 1/2*g*(EtaRxR^2 + 2*EtaRxR*Depthx)
! FyL = HyL*UyL*VyL
! FyR = HyR*UyR*VyR

! GxL = HxL*UxL*VxL
! GxR = HxR*UxR*VxR
! GyL = HVyL*VyL + 1/2*g*(EtaRyL^2 + 2*EtaRyL*Depthy)
! GyR = HVyR*VyR + 1/2*g*(EtaRyR^2 + 2*EtaRyR*Depthy) 





