

! ----------------------------------------------------
!    This is subroutine to read input.txt
!  called by 
!        MAIN
!    Last Update: 05/07/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------

SUBROUTINE READ_INPUT
    USE GLOBAL
    USE Input_Util
    IMPLICIT NONE
    CHARACTER(LEN=80) FILE_NAME
    INTEGER::LINE
    INTEGER :: ierr





      OPEN(3,FILE='LOG.txt')   

! read everything from input.txt
      FILE_NAME='input.txt'

! title
      CALL GET_STRING_VAL(TITLE,FILE_NAME,'TITLE',line,ierr)
      IF(ierr==1)THEN
        !write(*,*) 'No TITLE in ', FILE_NAME, 'use default'
        TITLE='---TEST RUN---'
      ENDIF





      WRITE(3,*)'---- LOG FILE ---'
      WRITE(3,*)TITLE
      WRITE(3,*)' --------------input start --------------'     

! hot start
    CALL GET_LOGICAL_VAL(HOT_START,FILE_NAME,'HOT_START',line)
      IF(HOT_START)THEN
      CALL GET_INTEGER_VAL(FileNumber_HOTSTART,FILE_NAME,'FileNumber_HOTSTART',line)



      WRITE(3,'(A21,I4)') 'FileNumber_HOTSTART=',FileNumber_HOTSTART

      ENDIF






! dimension
      CALL GET_INTEGER_VAL(Mglob,FILE_NAME,'Mglob',line)
      CALL GET_INTEGER_VAL(Nglob,FILE_NAME,'Nglob',line)



      WRITE(3,'(A7,I3,A7,I3)') 'Mglob=',Mglob,'Nglob=', Nglob

! grid 
      CALL GET_LOGICAL_VAL(StretchGrid,FILE_NAME,'StretchGrid',line)   
     if (StretchGrid) then
        CALL GET_STRING_VAL(DX_FILE,FILE_NAME,'DX_FILE',line,ierr)  
        CALL GET_STRING_VAL(DY_FILE,FILE_NAME,'DY_FILE',line,ierr)   
        CALL GET_STRING_VAL(Coriolis_FILE,FILE_NAME,'CORIOLIS_FILE',line,ierr)    
     else
      CALL GET_Float_VAL(Lon_West,FILE_NAME,'Lon_West',line)
      CALL GET_Float_VAL(Lat_South,FILE_NAME,'Lat_South',line)
      CALL GET_Float_VAL(Dphi,FILE_NAME,'Dphi',line)
      CALL GET_Float_VAL(Dtheta,FILE_NAME,'Dtheta',line)
     endif
      WRITE(3,'(A10,F12.2)')'Lon_West=',Lon_West
      WRITE(3,'(A11,F12.2)')'Lat_South=',Lat_South
      WRITE(3,'(A11,F12.2)')'Dphi     =',Dphi
      WRITE(3,'(A11,F12.2)')'Dtheta   =',Dtheta


! result folder
      CALL GET_STRING_VAL(RESULT_FOLDER,FILE_NAME,'RESULT_FOLDER',line,ierr)
      WRITE(3,'(A15,A50)')'RESULT_FOLDER:', RESULT_FOLDER
! station files
      CALL GET_INTEGER_VAL(NumberStations,FILE_NAME,'NumberStations',line)
      IF(NumberStations>0)THEN
      CALL GET_STRING_VAL(STATIONS_FILE,FILE_NAME,'STATIONS_FILE',line,ierr)
      ENDIF
! depth 
      CALL GET_STRING_VAL(DEPTH_TYPE,FILE_NAME,'DEPTH_TYPE',line,ierr)
      WRITE(3,'(A12,A50)')'DEPTH_TYPE:', DEPTH_TYPE
      IF(DEPTH_TYPE(1:3)=='DAT')THEN
        CALL GET_STRING_VAL(DEPTH_FILE,FILE_NAME,'DEPTH_FILE',line,ierr)
        CALL GET_STRING_VAL(DepthFormat,FILE_NAME,'DepthFormat',line,ierr)
      WRITE(3,'(A12,A50)')'DEPTH_FILE:', DEPTH_FILE
      WRITE(3,'(A14,A50)')'DEPTH_FORMAT:', DEPTHFORMAT
      ENDIF
      IF(DEPTH_TYPE(1:3)=='FLA')THEN
      CALL GET_Float_VAL(DEPTH_FLAT,FILE_NAME,'DEPTH_FLAT',line) 
      WRITE(3,'(A10,F12.2)')'DEPTH_FLAT=', DEPTH_FLAT 
      ENDIF
      IF(DEPTH_TYPE(1:3)=='SLO')THEN
      CALL GET_Float_VAL(DEPTH_FLAT,FILE_NAME,'DEPTH_FLAT',line) 
      CALL GET_Float_VAL(SLP,FILE_NAME,'SLP',line) 
      CALL GET_Float_VAL(Xslp,FILE_NAME,'Xslp',line) 
      WRITE(3,'(A10,F12.2)')'DEPTH_FLAT=', DEPTH_FLAT 
      WRITE(3,'(A5,F12.2)')'SLP=', SLP
      WRITE(3,'(A6,F12.2)')'Xslp=', Xslp  
      ENDIF
! time
      CALL GET_Float_VAL(TOTAL_TIME,FILE_NAME,'TOTAL_TIME',line)
      CALL GET_Float_VAL(PLOT_INTV,FILE_NAME,'PLOT_INTV',line)
      CALL GET_Float_VAL(PLOT_INTV_STATION,FILE_NAME,'PLOT_INTV_STATION',line)
      CALL GET_Float_VAL(SCREEN_INTV,FILE_NAME,'SCREEN_INTV',line)
      CALL GET_Float_VAL(HOTSTART_INTV,FILE_NAME,'HOTSTART_INTV',line)
      WRITE(3,'(A12,F12.2)')'TOTAL_TIME=', TOTAL_TIME
      WRITE(3,'(A12,F12.2)')'PLOT_INTV= ', PLOT_INTV
      WRITE(3,'(A13,F12.2)')'SCREEN_INTV=', SCREEN_INTV
      WRITE(3,'(A15,F12.2)')'HOTSTART_INTV=', HOTSTART_INTV

! initial uvz
      CALL GET_LOGICAL_VAL(INI_UVZ,FILE_NAME,'INI_UVZ',line)
      IF(INI_UVZ)THEN
        CALL GET_STRING_VAL(ETA_FILE,FILE_NAME,'ETA_FILE',line,ierr)
        CALL GET_STRING_VAL(U_FILE,FILE_NAME,'U_FILE',line,ierr)
        CALL GET_STRING_VAL(V_FILE,FILE_NAME,'V_FILE',line,ierr)
       ENDIF


! wavemaker
      CALL GET_STRING_VAL(WaveMaker,FILE_NAME,'WAVEMAKER',line,ierr)
      WRITE(3,'(A11,A50)')'WAVEMAKER:', WAVEMAKER
        IF(WaveMaker(1:7)=='LEF_SOL')THEN
          CALL GET_Float_VAL(AMP_SOLI,FILE_NAME,'AMP',line)
          CALL GET_Float_VAL(DEP_SOLI,FILE_NAME,'DEP',line)
          CALL GET_Float_VAL(LAG_SOLI,FILE_NAME,'LAGTIME',line)
      WRITE(3,'(A10,F12.2)')'AMP_SOLI=', AMP_SOLI
      WRITE(3,'(A10,F12.2)')'DEP_SOLI=', DEP_SOLI
      WRITE(3,'(A10,F12.2)')'LAG_SOLI=', LAG_SOLI
        ENDIF

        IF(WaveMaker(1:7)=='WK_TIME')THEN
        CALL GET_INTEGER_VAL(NumWaveComp,FILE_NAME,'NumWaveComp',line)
        CALL GET_Float_VAL(PeakPeriod,FILE_NAME,'PeakPeriod',line)
        CALL GET_STRING_VAL(WaveCompFile,FILE_NAME,'WaveCompFile',line,ierr)
          CALL GET_Float_VAL(Xc_WK,FILE_NAME,'Xc_WK',line)
          CALL GET_Float_VAL(DEP_WK,FILE_NAME,'DEP_WK',line)
          CALL GET_Float_VAL(Time_ramp,FILE_NAME,'Time_ramp',line)
          CALL GET_Float_VAL(Delta_WK,FILE_NAME,'Delta_WK',line)
          CALL GET_Float_VAL(Ywidth_WK,FILE_NAME,'Ywidth_WK',line)
      WRITE(3,'(A10,F12.2)')'Xc_WK   =', Xc_WK
      WRITE(3,'(A10,F12.2)')'DEP_WK  =', DEP_WK
      WRITE(3,'(A11,F12.2)')'Time_ramp=', Time_ramp
      WRITE(3,'(A11,F12.2)')'Delta_WK=', Delta_WK
      WRITE(3,'(A11,F12.2)')'Ywidth_WK=', Ywidth_WK

        ENDIF

        IF(WaveMaker(1:7)=='INI_SOL')THEN
          CALL GET_Float_VAL(AMP_SOLI,FILE_NAME,'AMP',line)
          CALL GET_Float_VAL(DEP_SOLI,FILE_NAME,'DEP',line)
          CALL GET_Float_VAL(XWAVEMAKER,FILE_NAME,'XWAVEMAKER',line)
      WRITE(3,'(A10,F12.2)')'AMP_SOLI=', AMP_SOLI
      WRITE(3,'(A10,F12.2)')'DEP_SOLI=', DEP_SOLI
        ENDIF
        IF(WaveMaker(1:6)=='N_WAVE')THEN
          CALL GET_Float_VAL(x1_Nwave,FILE_NAME,'x1_Nwave',line)
          CALL GET_Float_VAL(x2_Nwave,FILE_NAME,'x2_Nwave',line)
          CALL GET_Float_VAL(a0_Nwave,FILE_NAME,'a0_Nwave',line)
          CALL GET_Float_VAL(gamma_Nwave,FILE_NAME,'gamma_Nwave',line)
          CALL GET_Float_VAL(dep_Nwave,FILE_NAME,'dep_Nwave',line)
      WRITE(3,'(A10,F12.2)')'x1_Nwave=', x1_Nwave
      WRITE(3,'(A10,F12.2)')'x2_Nwave=', x2_Nwave
      WRITE(3,'(A10,F12.2)')'a0_Nwave=', a0_Nwave
      WRITE(3,'(A13,F12.2)')'gamma_Nwave=', gamma_Nwave
      WRITE(3,'(A11,F12.2)')'dep_Nwave=', dep_Nwave
        ENDIF

        IF(WaveMaker(1:7)=='INI_REC')THEN
          CALL GET_Float_VAL(AMP_SOLI,FILE_NAME,'AMP',line)
          CALL GET_Float_VAL(Xc,FILE_NAME,'Xc',line)
          CALL GET_Float_VAL(Yc,FILE_NAME,'Yc',line)
          CALL GET_Float_VAL(WID,FILE_NAME,'WID',line)
      WRITE(3,'(A10,F12.2)')'AMP     =', AMP_SOLI
      WRITE(3,'(A10,F12.2)')'Xc      =', Xc
      WRITE(3,'(A10,F12.2)')'Yc      =', Yc
      WRITE(3,'(A10,F12.2)')'WID     =', WID
        ENDIF

        IF(WaveMaker(1:7)=='INI_GAU')THEN
          CALL GET_Float_VAL(AMP_SOLI,FILE_NAME,'AMP',line)
          CALL GET_Float_VAL(Xc,FILE_NAME,'Xc',line)
          CALL GET_Float_VAL(Yc,FILE_NAME,'Yc',line)
          CALL GET_Float_VAL(WID,FILE_NAME,'WID',line)
      WRITE(3,'(A10,F12.2)')'AMP     =', AMP_SOLI
      WRITE(3,'(A10,F12.2)')'Xc      =', Xc
      WRITE(3,'(A10,F12.2)')'Yc      =', Yc
      WRITE(3,'(A12,F12.2)')'WID(gamma)=', WID
        ENDIF

        IF(WaveMaker(1:6)=='WK_REG')THEN
          CALL GET_Float_VAL(Xc_WK,FILE_NAME,'Xc_WK',line)
          CALL GET_Float_VAL(Tperiod,FILE_NAME,'Tperiod',line)
          CALL GET_Float_VAL(AMP_WK,FILE_NAME,'AMP_WK',line)
          CALL GET_Float_VAL(DEP_WK,FILE_NAME,'DEP_WK',line)
          CALL GET_Float_VAL(Theta_WK,FILE_NAME,'Theta_WK',line)
          CALL GET_Float_VAL(Time_ramp,FILE_NAME,'Time_ramp',line)
          CALL GET_Float_VAL(Delta_WK,FILE_NAME,'Delta_WK',line)
          CALL GET_Float_VAL(Ywidth_WK,FILE_NAME,'Ywidth_WK',line)
      WRITE(3,'(A10,F12.2)')'Xc_WK   =', Xc_WK
      WRITE(3,'(A10,F12.2)')'Tperiod =', Tperiod
      WRITE(3,'(A10,F12.2)')'AMP_WK  =', AMP_WK
      WRITE(3,'(A10,F12.2)')'DEP_WK  =', DEP_WK
      WRITE(3,'(A10,F12.2)')'Theta_WK=', Theta_WK
      WRITE(3,'(A11,F12.2)')'Time_ramp=', Time_ramp
      WRITE(3,'(A11,F12.2)')'Delta_WK=', Delta_WK
      WRITE(3,'(A11,F12.2)')'Ywidth_WK=', Ywidth_WK
        ENDIF
        IF(WaveMaker(1:6)=='WK_IRR')THEN
          CALL GET_Float_VAL(Xc_WK,FILE_NAME,'Xc_WK',line)
          CALL GET_Float_VAL(DEP_WK,FILE_NAME,'DEP_WK',line)
          CALL GET_Float_VAL(Time_ramp,FILE_NAME,'Time_ramp',line)
          CALL GET_Float_VAL(Delta_WK,FILE_NAME,'Delta_WK',line)
          CALL GET_Float_VAL(FreqPeak,FILE_NAME,'FreqPeak',line)
          CALL GET_Float_VAL(FreqMin,FILE_NAME,'FreqMin',line)
          CALL GET_Float_VAL(FreqMax,FILE_NAME,'FreqMax',line)
          CALL GET_Float_VAL(Hmo,FILE_NAME,'Hmo',line)
          CALL GET_Float_VAL(GammaTMA,FILE_NAME,'GammaTMA',line)
          CALL GET_Float_VAL(ThetaPeak,FILE_NAME,'ThetaPeak',line)
          CALL GET_Float_VAL(Sigma_Theta,FILE_NAME,'Sigma_Theta',line)
          CALL GET_Float_VAL(Ywidth_WK,FILE_NAME,'Ywidth_WK',line)
      WRITE(3,'(A12,F12.2)')'Xc_WK   =  ', Xc_WK
      WRITE(3,'(A11,F12.2)')'Ywidth_WK=', Ywidth_WK
      WRITE(3,'(A12,F12.2)')'DEP_WK  =  ', DEP_WK
      WRITE(3,'(A12,F12.2)')'Time_ramp= ', Time_ramp
      WRITE(3,'(A12,F12.2)')'Delta_WK=  ', Delta_WK
      WRITE(3,'(A12,F12.2)')'FreqPeak=  ', FreqPeak
      WRITE(3,'(A12,F12.2)')'FreqMin =  ', FreqMin
      WRITE(3,'(A12,F12.2)')'FreqMax =  ', FreqMax
      WRITE(3,'(A12,F12.2)')'Hmo     =  ', Hmo
      WRITE(3,'(A12,F12.2)')'GammaTMA=  ', GammaTMA
      WRITE(3,'(A12,F12.2)')'ThetaPeak= ', ThetaPeak
      WRITE(3,'(A13,F12.2)')'Sigma_Theta=', Sigma_Theta
        ENDIF
! ****
        IF(WaveMaker(1:9)=='WK_DATA2D')THEN
          CALL GET_Float_VAL(Xc_WK,FILE_NAME,'Xc_WK',line)
          CALL GET_Float_VAL(DEP_WK,FILE_NAME,'DEP_WK',line)
          CALL GET_Float_VAL(Time_ramp,FILE_NAME,'Time_ramp',line)
          CALL GET_Float_VAL(Delta_WK,FILE_NAME,'Delta_WK',line)
!          CALL GET_Float_VAL(PeakPeriod,FILE_NAME,'PeakPeriod',line)
!          CALL GET_INTEGER_VAL(NumFreq,FILE_NAME,'NumFreq',line)
!          CALL GET_INTEGER_VAL(NumDir,FILE_NAME,'NumDir',line)
          CALL GET_STRING_VAL(WaveCompFile,FILE_NAME,'WaveCompFile',line,ierr)
          CALL GET_Float_VAL(Ywidth_WK,FILE_NAME,'Ywidth_WK',line)
      WRITE(3,'(A12,F12.2)')'Xc_WK   =  ', Xc_WK
      WRITE(3,'(A11,F12.2)')'Ywidth_WK=', Ywidth_WK
      WRITE(3,'(A12,F12.2)')'DEP_WK  =  ', DEP_WK
      WRITE(3,'(A12,F12.2)')'Time_ramp= ', Time_ramp
      WRITE(3,'(A12,F12.2)')'Delta_WK=  ', Delta_WK
!      WRITE(3,'(A12,F12.2)')'FreqPeak=  ', FreqPeak
!      WRITE(3,'(A12,I5)')'NumFreq=  ', NumFreq
!      WRITE(3,'(A12,I5)')'NumDir =  ', NumDir
        ENDIF
! ******

! sponge layer
      CALL GET_LOGICAL_VAL(SPONGE_ON,FILE_NAME,'SPONGE_ON',line)
      WRITE(3,'(A11,A50)')'SPONGE_ON:', SPONGE_ON
      IF(SPONGE_ON)THEN
        CALL GET_Float_VAL(Sponge_west_width,FILE_NAME,'Sponge_west_width',line)
        CALL GET_Float_VAL(Sponge_east_width,FILE_NAME,'Sponge_east_width',line)
        CALL GET_Float_VAL(Sponge_south_width,FILE_NAME,'Sponge_south_width',line)
        CALL GET_Float_VAL(Sponge_north_width,FILE_NAME,'Sponge_north_width',line)
        CALL GET_Float_VAL(R_sponge,FILE_NAME,'R_sponge',line)
        CALL GET_Float_VAL(A_sponge,FILE_NAME,'A_sponge',line)
        WRITE(3,'(A20,F12.2)')'Sponge_west_width =', Sponge_west_width
        WRITE(3,'(A20,F12.2)')'Sponge_east_width =', Sponge_east_width
        WRITE(3,'(A20,F12.2)')'Sponge_south_width=', Sponge_south_width
        WRITE(3,'(A20,F12.2)')'Sponge_north_width=', Sponge_north_width
        WRITE(3,'(A20,F12.2)')'R_sponge          =', R_sponge
        WRITE(3,'(A20,F12.2)')'A_sponge          =', A_sponge
      ENDIF

! obstacle structures
      CALL GET_STRING_VAL(OBSTACLE_FILE,FILE_NAME,'OBSTACLE_FILE',line,ierr)
      IF(ierr==1)THEN
        OBSTACLE=.FALSE.
      WRITE(3,'(A15,A5)')'OBSTACLE_FILE:', 'NO'
      ELSE
        OBSTACLE=.TRUE.
      WRITE(3,'(A15,A50)')'OBSTACLE_FILE:', OBSTACLE_FILE
      ENDIF
! physics
          CALL GET_LOGICAL_VAL(DISPERSION,FILE_NAME,'DISPERSION',line)
          CALL GET_Float_VAL(Gamma1,FILE_NAME,'Gamma1',line)
          CALL GET_Float_VAL(Gamma3,FILE_NAME,'Gamma3',line)
      WRITE(3,'(A8)')'Physics'


       WRITE(3,'(A10,F12.2)')'Gamma1 = ', Gamma1
       WRITE(3,'(A10,F12.2)')'Gamma3 = ', Gamma3

      CALL GET_Float_VAL(SWE_ETA_DEP,FILE_NAME,'SWE_ETA_DEP',line)
       WRITE(3,'(A13,F12.2)')'SWE_ETA_DEP=', SWE_ETA_DEP
      CALL GET_Float_VAL(Cd,FILE_NAME,'Cd',line)
       WRITE(3,'(A13,F12.2)')'Cd         =', Cd
! numerics schemes
      CALL GET_STRING_VAL(Time_Scheme,FILE_NAME,'Time_Scheme',line,ierr)
      IF(ierr==1)THEN
        !write(*,*) 'Please define Time_Scheme in ', FILE_NAME
      WRITE(3,'(A13,A50)')'TIME_SCHEME:', 'NOT DEFINED, STOP'
        STOP
      ENDIF
      WRITE(3,'(A13,A50)')'TIME_SCHEME:', TIME_SCHEME
      CALL GET_STRING_VAL(CONSTR,FILE_NAME,'CONSTRUCTION',line,ierr)
      IF(ierr==1)THEN
        !write(*,*) 'No definition of CONSTRUCTION in ', FILE_NAME, 'use default'
      WRITE(3,'(A14,A50)')'CONSTRUCTION', 'NOT DEFINED, USE DEFAULT'
        CONSTR='HLLC'
      ENDIF
      WRITE(3,'(A14,A50)')'CONSTRUCTION:', CONSTR
      CALL GET_STRING_VAL(HIGH_ORDER,FILE_NAME,'HIGH_ORDER',line,ierr)
      IF(ierr==1)THEN
        !write(*,*) 'No definition of HIGH_ORDER in ', FILE_NAME, 'use default'
      WRITE(3,'(A12,A50)')'HIGH_ORDER', 'NOT DEFINED, USE DEFAULT'
        HIGH_ORDER='FOURTH'        
      ENDIF
      WRITE(3,'(A12,A50)')'HIGH_ORDER:', HIGH_ORDER
! CFL
      CALL GET_Float_VAL(CFL,FILE_NAME,'CFL',line)
      WRITE(3,'(A5,F12.2)')'CFL=', CFL
! Froude Number Cap
      CALL GET_Float_VAL(FroudeCap,FILE_NAME,'FroudeCap',line)
      WRITE(3,'(A5,F12.2)')'FroudeCap=', FroudeCap
! MinDepth etc
      CALL GET_Float_VAL(MinDepth,FILE_NAME,'MinDepth',line)
      WRITE(3,'(A10,F12.6)')'MinDepth=', MinDepth
      CALL GET_Float_VAL(MinDepthFrc,FILE_NAME,'MinDepthFrc',line)
      WRITE(3,'(A13,F12.2)')'MinDepthFrc=', MinDepthFrc

! show breaking
      CALL GET_LOGICAL_VAL(SHOW_BREAKING,FILE_NAME,'SHOW_BREAKING',line)
      IF(SHOW_BREAKING)THEN
      CALL GET_Float_VAL(Cbrk1,FILE_NAME,'Cbrk1',line)
      WRITE(3,'(A8,F12.6)')'Cbrk1 =', Cbrk1
      CALL GET_Float_VAL(Cbrk2,FILE_NAME,'Cbrk2',line)
      WRITE(3,'(A8,F12.6)')'Cbrk2 =', Cbrk2
      ENDIF


! output parameters
      CALL GET_LOGICAL_VAL(OUT_DEPTH,FILE_NAME,'DEPTH_OUT',line)
      CALL GET_LOGICAL_VAL(OUT_U,FILE_NAME,'U',line)
      CALL GET_LOGICAL_VAL(OUT_V,FILE_NAME,'V',line)
      CALL GET_LOGICAL_VAL(OUT_ETA,FILE_NAME,'ETA',line)
      CALL GET_LOGICAL_VAL(OUT_Hmax,FILE_NAME,'Hmax',line)
      CALL GET_LOGICAL_VAL(OUT_MASK,FILE_NAME,'MASK',line)
      CALL GET_LOGICAL_VAL(OUT_MASK9,FILE_NAME,'MASK9',line)
      CALL GET_LOGICAL_VAL(OUT_SXL,FILE_NAME,'SXL',line)
      CALL GET_LOGICAL_VAL(OUT_SXR,FILE_NAME,'SXR',line)
      CALL GET_LOGICAL_VAL(OUT_SYL,FILE_NAME,'SYL',line)
      CALL GET_LOGICAL_VAL(OUT_SYR,FILE_NAME,'SYR',line)
      CALL GET_LOGICAL_VAL(OUT_SourceX,FILE_NAME,'SourceX',line)
      CALL GET_LOGICAL_VAL(OUT_SourceY,FILE_NAME,'SourceY',line)
      CALL GET_LOGICAL_VAL(OUT_P,FILE_NAME,'P',line)
      CALL GET_LOGICAL_VAL(OUT_Q,FILE_NAME,'Q',line)
      CALL GET_LOGICAL_VAL(OUT_Fx,FILE_NAME,'Fx',line)
      CALL GET_LOGICAL_VAL(OUT_Fy,FILE_NAME,'Fy',line)
      CALL GET_LOGICAL_VAL(OUT_Gx,FILE_NAME,'Gx',line)
      CALL GET_LOGICAL_VAL(OUT_Gy,FILE_NAME,'Gy',line)
      CALL GET_LOGICAL_VAL(OUT_AGE,FILE_NAME,'AGE',line)
      CALL GET_LOGICAL_VAL(OUT_TMP,FILE_NAME,'TMP',line)

! 
      WRITE(3,*)' --------------input end --------------' 

END SUBROUTINE READ_INPUT


SUBROUTINE STATIONS
     USE GLOBAL
     IMPLICIT NONE

     INTEGER :: iunit
     REAL(SP) :: dum1,dum2
     CHARACTER(LEN=80)::FILE_NAME=''
     CHARACTER(LEN=80)::TMP_NAME=''
     CHARACTER(LEN=80)::FDIR=''

! initialize stations
     FDIR=TRIM(RESULT_FOLDER)
     if (icount.eq.0) then
       ALLOCATE(ista(NumberStations),&
                jsta(NumberStations),&
                nsta(NumberStations))
! calculate how many output components
              
       open(100,FILE=TRIM(STATIONS_FILE))
       do i=1,NumberStations
          read(100,*) dum1,dum2
          ista(i) = Nghost+dum1
          jsta(i) = Nghost+dum2
          if ((ista(i).ge.Ibeg).and.(ista(i).le.Iend).and.&
              (jsta(i).ge.Jbeg).and.(jsta(i).le.Jend)) then
             nsta(i) = 1
             write(file_name(1:4),'(I4.4)') i
             TMP_NAME = TRIM(FDIR)//'sta_'//TRIM(FILE_NAME)
             iunit=100+i
             open(iunit,FILE=TMP_NAME)
          else
             nsta(i) = 0
          endif
       enddo
     endif

! write to stations

     do i=1,NumberStations
       if (nsta(i).eq.1) then
          iunit=100+i
          write (iunit,'(20E16.5)') time, eta(ista(i),jsta(i)),&
                          u(ista(i),jsta(i)),v(ista(i),jsta(i))
       endif
     enddo

! close station files
     if (TIME.ge.TOTAL_TIME) then
       do i=1,NumberStations
          if (nsta(i).eq.1) then
             iunit=100+i
             close(iunit)
          endif
       enddo
     endif

END SUBROUTINE STATIONS

! -------------
!    Writes station data,  works in spherical
! Jeff Harris did this 04/05/2011
! -------------
SUBROUTINE STATIONS_JEFF
     USE GLOBAL
     IMPLICIT NONE

     INTEGER :: iunit
     REAL(SP) :: dum1,dum2
     CHARACTER(LEN=80)::FILE_NAME=''
     CHARACTER(LEN=80)::TMP_NAME=''
     CHARACTER(LEN=80)::FDIR=''

! initialize stations
     FDIR=TRIM(RESULT_FOLDER)
     if (icount.eq.0) then
       ALLOCATE(ista(NumberStations),&
                jsta(NumberStations),&
                nsta(NumberStations))
!       ALLOCATE(envelope(Mloc,Nloc))
!       envelope = 0.d0
       open(100,FILE=TRIM(STATIONS_FILE))
       do i=1,NumberStations
          read(100,*) dum1,dum2
          ista(i) = Nghost+1+nint((dum2-Lon_West)/Dphi) 
          jsta(i) = Nghost+1+nint((dum1-Lat_South)/Dtheta) 
          if ((ista(i).ge.Ibeg).and.(ista(i).le.Iend).and.&
              (jsta(i).ge.Jbeg).and.(jsta(i).le.Jend)) then
             nsta(i) = 1
             write(file_name(1:4),'(I4.4)') i
             TMP_NAME = TRIM(FDIR)//'sta_'//TRIM(FILE_NAME)
             iunit=100+i
             open(iunit,FILE=TMP_NAME)
          else
             nsta(i) = 0
          endif
       enddo
     endif

! write to stations
     do j=1,Nloc
     do i=1,Mloc
!       envelope(i,j) = max(envelope(i,j),eta(i,j))
         IF(MASK(I,J).GT.0)THEN
         IF(Eta(I,J).GT.HeightMax(I,J)) HeightMax(I,J)=Eta(I,J)
         ENDIF
     enddo
     enddo

     do i=1,NumberStations
       if (nsta(i).eq.1) then
          iunit=100+i
          write (iunit,*) time, eta(ista(i),jsta(i)),u(ista(i),jsta(i)),&
                                v(ista(i),jsta(i))
       endif
     enddo

! close station files
     if (TIME.ge.TOTAL_TIME) then
!       TMP_NAME = TRIM(FDIR)//'envelope.out'
!       call PutFile(TMP_NAME,envelope)
       do i=1,NumberStations
          if (nsta(i).eq.1) then
             iunit=100+i
             close(iunit)
          endif
       enddo
     endif

END SUBROUTINE STATIONS_JEFF


! ----------------------------------------------------
!    This is subroutine for preview
!  called by 
!        MAIN
!    Last Update: 05/06/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE PREVIEW
     USE GLOBAL
     IMPLICIT NONE

     CHARACTER(LEN=80)::FILE_NAME=''
     CHARACTER(LEN=80)::TMP_NAME=''
     CHARACTER(LEN=80)::FDIR=''

     FDIR=TRIM(RESULT_FOLDER)

     ICOUNT=ICOUNT+1

        WRITE(*,102)'PRINTING FILE NO.', icount, ' TIME/TOTAL: ', TIME,'/',Total_Time
102     FORMAT(A20,I4,A14,F12.3,A2,F12.3)

        itmp1=mod(icount/1000,10)
        itmp2=mod(icount/100,10)
        itmp3=mod(icount/10,10)
        itmp4=mod(icount,10)

        write(file_name(1:1),'(I1)')itmp1
        write(file_name(2:2),'(I1)')itmp2
        write(file_name(3:3),'(I1)')itmp3
        write(file_name(4:4),'(I1)')itmp4

     IF(ICOUNT==1)THEN
     IF(OUT_DEPTH)THEN
        TMP_NAME = TRIM(FDIR)//'dep.out'
        call PutFile(TMP_NAME,DEPTH)
     ENDIF
     ENDIF

     IF(OUT_ETA)THEN
        TMP_NAME = TRIM(FDIR)//'eta_'//TRIM(FILE_NAME)
        call PutFile(TMP_NAME,Eta)
     ENDIF

     IF(OUT_Hmax)THEN
        TMP_NAME = TRIM(FDIR)//'hmax_'//TRIM(FILE_NAME)
        call PutFile(TMP_NAME,HeightMax)
     ENDIF


     IF(OUT_U)THEN
        TMP_NAME = TRIM(FDIR)//'u_'//TRIM(FILE_NAME)
        call PutFile(TMP_NAME,U)
     ENDIF

     IF(OUT_V)THEN
        TMP_NAME = TRIM(FDIR)//'v_'//TRIM(FILE_NAME)
        call PutFile(TMP_NAME,V)
     ENDIF

     IF(OUT_MASK)THEN
        TMP_NAME = TRIM(FDIR)//'mask_'//TRIM(FILE_NAME)
        Int2Flo=MASK
        call PutFile(TMP_NAME,Int2Flo)
     ENDIF

     IF(OUT_MASK9)THEN
        TMP_NAME = TRIM(FDIR)//'mask9_'//TRIM(FILE_NAME)
        Int2Flo=MASK9
        call PutFile(TMP_NAME,Int2Flo)
     ENDIF

210   FORMAT(5000I3)

     IF(OUT_P)THEN
        TMP_NAME = TRIM(FDIR)//'p_'//TRIM(FILE_NAME)
!        call PutFile(TMP_NAME,P)
     ENDIF

     IF(OUT_Q)THEN
        TMP_NAME = TRIM(FDIR)//'q_'//TRIM(FILE_NAME)
!        call PutFile(TMP_NAME,Q)
     ENDIF


     IF(OUT_AGE)THEN
        TMP_NAME = TRIM(FDIR)//'age_'//TRIM(FILE_NAME)
         call PutFile(TMP_NAME,AGE_BREAKING)
     ENDIF

     IF(OUT_TMP)THEN
        TMP_NAME = TRIM(FDIR)//'tmp_'//TRIM(FILE_NAME)
        call PutFile(TMP_NAME,tmp4preview)
     ENDIF

101   continue

END SUBROUTINE PREVIEW


SUBROUTINE PutFile(FILE,PHI)
     USE PARAM
     USE GLOBAL
     IMPLICIT NONE
     REAL(SP),DIMENSION(Mloc,Nloc),INTENT(IN) :: PHI
     CHARACTER(LEN=80) FILE
        OPEN(1,FILE=TRIM(FILE))
        DO J=Nghost+1,Nloc-Nghost
           WRITE(1,100)(real(PHI(I,J)),I=Nghost+1,Mloc-Nghost)
        ENDDO
100  FORMAT(5000E16.6)
        CLOSE(1)
END SUBROUTINE PutFile


! --------------------------------------------------
!    This is subroutine to read hot start data and initialize other 
!    variables
!    called by
!       MAIN
!    
!    Last Update: 10/21/2010 Fengyan Shi, University of Delaware
! --------------------------------------------------
SUBROUTINE READ_HOTSTART_DATA
     USE GLOBAL
     IMPLICIT NONE
     CHARACTER(LEN=80)::FDIR=''
     CHARACTER(LEN=80)::WHAT
     INTEGER :: Icontr
     INTEGER :: RMloc,RNloc,RNghost
     REAL(SP) :: RTOTAL_TIME,RPLOT_INTV,RSCREEN_INTV,RHOTSTART_INTV
     REAL(SP) :: RDX,RDY
     LOGICAL :: RDISPERSION,RSPONGE_ON
     LOGICAL :: RSHOW_BREAKING
     REAL(SP) :: RGamma1,RSWE_ETA_DEP
     CHARACTER(LEN=80) RTime_Scheme
     CHARACTER(LEN=80) RCONSTR
     CHARACTER(LEN=80) RHIGH_ORDER
     REAL(SP) :: RCFL,RFroudeCap
     REAL(SP) :: RMinDepth,RMinDepthfrc
     REAL(SP) :: RSponge_west_width,RSponge_east_width, &
                 RSponge_south_width,RSponge_north_width, &
                 RR_sponge,RA_sponge
     CHARACTER(LEN=80)::FILE_NAME=''


        itmp1=mod(FileNumber_HOTSTART/1000,10)
        itmp2=mod(FileNumber_HOTSTART/100,10)
        itmp3=mod(FileNumber_HOTSTART/10,10)
        itmp4=mod(FileNumber_HOTSTART,10)


        !write(file_name(1:1),'(I1)')itmp1
        !write(file_name(2:2),'(I1)')itmp2
        !write(file_name(3:3),'(I1)')itmp3
        !write(file_name(4:4),'(I1)')itmp4

     FDIR=TRIM(RESULT_FOLDER)
     
     !WRITE(*,*)'READ IN HOT START DATA ...'
     
     OPEN(4,FILE=TRIM(FDIR)//'hotstart.'//TRIM(FILE_NAME))
! -- dimension
     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)RMloc,RNloc,Mloc1,Nloc1,Ibeg,Iend,Jbeg,Jend,Iend1,Jend1,RNghost
     IF(RMloc.NE.Mloc.OR.RNloc.NE.Nloc.OR.RNghost.NE.Nghost)THEN
       !WRITE(*,*)'Mloc,Nloc,or Nghost not consistent with previous ones'
       !WRITE(*,*)'Mloc,Nloc,Nghost',Mloc,Nloc,Nghost
       STOP
     ENDIF
! -- time
     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)TIME,RTOTAL_TIME,RPLOT_INTV,PLOT_COUNT,&
               RSCREEN_INTV,SCREEN_COUNT,RHOTSTART_INTV
     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)ICOUNT
     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)ICOUNT_HOTSTART

     IF(RTOTAL_TIME.NE.TOTAL_TIME)THEN
       !WRITE(*,*)'TOTAL_TIME is not consistent with previous one'
       !WRITE(*,*) 'previous TOTAL_TIME=',RTOTAL_TIME
       !WRITE(*,*) 'present  TOTAL_TIME=',TOTAL_TIME
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF

     IF(RPLOT_INTV.NE.PLOT_INTV)THEN
       !WRITE(*,*)'PLOT_INTV is not consistent with previous one'
       !WRITE(*,*) 'previous PLOT_INTV=',RPLOT_INTV
       !WRITE(*,*) 'present  PLOT_INTV=',PLOT_INTV
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF

     IF(RSCREEN_INTV.NE.SCREEN_INTV)THEN
       !WRITE(*,*)'SCREEN_INTV is not consistent with previous one'
       !WRITE(*,*) 'previous SCREEN_INTV=',RSCREEN_INTV
       !WRITE(*,*) 'present  SCREEN_INTV=',SCREEN_INTV
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF

     IF(RHOTSTART_INTV.NE.HOTSTART_INTV)THEN
       !WRITE(*,*)'HOTSTART_INTV is not consistent with previous one'
       !WRITE(*,*) 'previous HOTSTART_INTV=',RHOTSTART_INTV
       !WRITE(*,*) 'present  HOTSTART_INTV=',HOTSTART_INTV
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF

! -- physics
! DISPERSION
     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)RDISPERSION

     IF(RDISPERSION.NEQV.DISPERSION)THEN
       !WRITE(*,*)'DISPERSION setting is not consistent with previous one'
       !WRITE(*,*) 'previous DISPERSION',RDISPERSION
       !WRITE(*,*) 'present  DISPERSION',DISPERSION
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF

     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)RGamma1,a1,a2,b1,b2,RSWE_ETA_DEP

     IF(RGamma1.NE.Gamma1)THEN
       !WRITE(*,*)'Gamma1 is not consistent with previous one'
       !WRITE(*,*) 'previous Gamma1=',RGamma1
       !WRITE(*,*) 'present  Gamma1=',Gamma1
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF


     IF(RSWE_ETA_DEP.NE.SWE_ETA_DEP)THEN
       !WRITE(*,*)'SWE_ETA_DEP is not consistent with previous one'
       !WRITE(*,*) 'previous SWE_ETA_DEP=',RSWE_ETA_DEP
       !WRITE(*,*) 'present  SWE_ETA_DEP=',SWE_ETA_DEP
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF

! -- numerics
     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)RTime_Scheme

     IF(RTime_Scheme(1:3).NE.Time_Scheme(1:3))THEN
       !WRITE(*,*)'Time_Scheme is not consistent with previous one'
       !WRITE(*,*) 'previous Time_Scheme=',RTime_Scheme
       !WRITE(*,*) 'present  Time_Scheme=',Time_Scheme
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF
     
     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)RHIGH_ORDER,RCONSTR

     IF(RHIGH_ORDER(1:3).NE.HIGH_ORDER(1:3))THEN
       !WRITE(*,*)'HIGH_ORDER is not consistent with previous one'
       !WRITE(*,*) 'previous HIGH_ORDER=',RHIGH_ORDER
       !WRITE(*,*) 'present  HIGH_ORDER=',HIGH_ORDER
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF

     IF(RCONSTR(1:3).NE.CONSTR(1:3))THEN
       !WRITE(*,*)'CONSTR is not consistent with previous one'
       !WRITE(*,*) 'previous CONSTR=',RCONSTR
       !WRITE(*,*) 'present  CONSTR=',CONSTR
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF

     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)RCFL,RFroudeCap

     IF(RCFL.NE.CFL)THEN
       !WRITE(*,*)'CFL is not consistent with previous one'
       !WRITE(*,*) 'previous CFL=',RCFL
       !WRITE(*,*) 'present  CFL=',CFL
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF

     IF(RFroudeCap.NE.FroudeCap)THEN
       !WRITE(*,*)'FroudeCap is not consistent with previous one'
       !WRITE(*,*) 'previous FroudeCap=',RFroudeCap
       !WRITE(*,*) 'present  FroudeCap=',FroudeCap
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF


     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)DISP_TIME_LEFT

! -- wet-dry
     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)RMinDepth,RMinDepthfrc

     IF(RMinDepthfrc.NE.MinDepthfrc)THEN
       !WRITE(*,*)'MinDepthfrc is not consistent with previous one'
       !WRITE(*,*) 'previous MinDepthfrc=',RMinDepthfrc
       !WRITE(*,*) 'present  MinDepthfrc=',MinDepthfrc
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF

     IF(RMinDepth.NE.MinDepth)THEN
       !WRITE(*,*)'MinDepth is not consistent with previous one'
       !WRITE(*,*) 'previous MinDepth=',RMinDepth
       !WRITE(*,*) 'present  MinDepth=',MinDepth
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF

! -- depth

     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)((DEPTH(I,J),I=1,Mloc),J=1,Nloc)
     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)((DEPTHx(I,J),I=1,Mloc),J=1,Nloc)
     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)((DEPTHy(I,J),I=1,Mloc),J=1,Nloc)
! variables
     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)((U(I,J),I=1,Mloc),J=1,Nloc)
     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)

     READ(4,*)((V(I,J),I=1,Mloc),J=1,Nloc)

     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)((U0(I,J),I=1,Mloc),J=1,Nloc)

     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)((V0(I,J),I=1,Mloc),J=1,Nloc)

     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)((Ubar(I,J),I=1,Mloc),J=1,Nloc)

     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)((Vbar(I,J),I=1,Mloc),J=1,Nloc)

     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)((ETA(I,J),I=1,Mloc),J=1,Nloc)

     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)((H(I,J),I=1,Mloc),J=1,Nloc)

     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)((MASK(I,J),I=1,Mloc),J=1,Nloc)

     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)((MASK9(I,J),I=1,Mloc),J=1,Nloc)

     READ(4,'(A80)')WHAT
     !WRITE(*,*)'READ',TRIM(WHAT)
     READ(4,*)((MASK_STRUC(I,J),I=1,Mloc),J=1,Nloc)

! sponge
      READ(4,'(A80)')WHAT
      !WRITE(*,*)'READ',TRIM(WHAT)
      READ(4,*) RSPONGE_ON
     IF(RSPONGE_ON.NEQV.SPONGE_ON)THEN
       !WRITE(*,*)'SPONGE_ON is not consistent with previous one'
       !WRITE(*,*) 'previous SPONGE_ON',RSPONGE_ON
       !WRITE(*,*) 'present  SPONGE_ON',SPONGE_ON
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF
  
      READ(4,'(A80)')WHAT
      !WRITE(*,*)'READ',TRIM(WHAT)
      READ(4,*)RSponge_west_width,RSponge_east_width, &
                 RSponge_south_width,RSponge_north_width
     IF(RSponge_west_width.NE.Sponge_west_width.OR.&
        RSponge_east_width.NE.Sponge_east_width.OR.&
        RSponge_south_width.NE.Sponge_south_width.OR.&
        RSponge_north_width.NE.Sponge_north_width)THEN
       !WRITE(*,*)'SPONGE width is not consistent with previous one'
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF

  
      READ(4,'(A80)')WHAT
      !WRITE(*,*)'READ',TRIM(WHAT)
      READ(4,*)RR_sponge,RA_sponge
     IF(RR_sponge.NE.R_sponge.OR.&
        RA_sponge.NE.A_sponge)THEN
       !WRITE(*,*)'SPONGE R and A are not consistent with previous ones'
       !WRITE(*,*)'PRESS 1 TO ACCEPT NEW ONE, OTHER KEY TO STOP'
       READ(*,*) Icontr
       IF(Icontr.NE.1)THEN
         STOP
       ENDIF
     ENDIF

      READ(4,'(A80)')WHAT
      !WRITE(*,*)'READ',TRIM(WHAT)
      READ(4,*)RSHOW_BREAKING
     IF(RSHOW_BREAKING.NEQV.SHOW_BREAKING)THEN
       !WRITE(*,*)'SHOW_BREAKING is not consistent with previous one'
       !WRITE(*,*) 'previous SHOW_BREAKING',RSHOW_BREAKING
       !WRITE(*,*) 'present  SHOW_BREAKING',SHOW_BREAKING
       !WRITE(*,*)'STOP'
         STOP
     ENDIF

      IF(SHOW_BREAKING)THEN
      READ(4,'(A80)')WHAT
      !WRITE(*,*)'READ',TRIM(WHAT)
      READ(4,*)((AGE_BREAKING(I,J),I=1,Mloc),J=1,Nloc)
      ENDIF


! wavemaker
! data for irregular wave case too large, recalculate when hotstart
!      IF(WAVEMAKER(1:6)=='WK_IRR')THEN
!       READ(4,'(A80)')WHAT
!       !WRITE(*,*)'READ',TRIM(WHAT)
!       READ(4,*)(OMGN_IR(I),I=1,Nfreq)
!       READ(4,'(A80)')WHAT
!       !WRITE(*,*)'READ',TRIM(WHAT)
!       READ(4,*)(((Cm(I,J,K),I=1,Mloc),J=1,Nloc),K=1,Nfreq)
!       READ(4,'(A80)')WHAT
!       !WRITE(*,*)'READ',TRIM(WHAT)
!       READ(4,*)(((Sm(I,J,K),I=1,Mloc),J=1,Nloc),K=1,Nfreq)
!      ENDIF
!      IF(WAVEMAKER(1:6)=='WK_REG')THEN
!       READ(4,'(A80)')WHAT
!       !WRITE(*,*)'READ',TRIM(WHAT)
!       READ(4,*) D_gen,Beta_gen,rlamda
!      ENDIF
    
     CLOSE(4)

     !WRITE(*,*)'READ HOT START DATA OVER!'
    
     CLOSE(4)

END SUBROUTINE READ_HOTSTART_DATA


SUBROUTINE WRITE_HOTSTART_DATA
     USE GLOBAL
     IMPLICIT NONE
     CHARACTER(LEN=80)::FDIR=''
     CHARACTER(LEN=80)::FILE_NAME=''


     FDIR=TRIM(RESULT_FOLDER)

     ICOUNT_HOTSTART=ICOUNT_HOTSTART+1

        WRITE(*,102)'HOTSTART FILE NO.', icount_hotstart
102     FORMAT(A20,I4)

        itmp1=mod(icount_hotstart/1000,10)
        itmp2=mod(icount_hotstart/100,10)
        itmp3=mod(icount_hotstart/10,10)
        itmp4=mod(icount_hotstart,10)


        !write(file_name(1:1),'(I1)')itmp1
        !write(file_name(2:2),'(I1)')itmp2
        !write(file_name(3:3),'(I1)')itmp3
        !write(file_name(4:4),'(I1)')itmp4

     !WRITE(*,*)'!WRITE OUT HOT START DATA ...'
     
     OPEN(4,FILE=TRIM(FDIR)//'hotstart.'//TRIM(FILE_NAME))
! -- dimension
     !WRITE(4,*)'# Mloc,Nloc,Mloc1,Nloc1,Ibeg,Iend,Jbeg,Jend,Iend1,Jend1,Nghost'
     !WRITE(4,*)Mloc,Nloc,Mloc1,Nloc1,Ibeg,Iend,Jbeg,Jend,Iend1,Jend1,Nghost
! -- time
     !WRITE(4,*)'# TIME,TOTAL_TIME,PLOT_INTV,PLOT_COUNT'
     !WRITE(4,*)'# SCREEN_INTV,SCREEN_COUNT,HOTSTART_INTV'
     !WRITE(4,*)TIME,TOTAL_TIME,PLOT_INTV,PLOT_COUNT,&
!               SCREEN_INTV,SCREEN_COUNT,HOTSTART_INTV
     !WRITE(4,*)'# ICOUNT'
     !WRITE(4,*)ICOUNT
     !WRITE(4,*)'# ICOUNT_HOTSTART'
     !WRITE(4,*)ICOUNT_HOTSTART
! -- physics
! DISPERSION
     !WRITE(4,*)'# DISPERSION'
     !WRITE(4,*)DISPERSION

     !WRITE(4,*)'# Gamma1,a1,a2,b1,b2,SWE_ETA_DEP'
     !WRITE(4,*)Gamma1,a1,a2,b1,b2,SWE_ETA_DEP
! -- numerics
     !WRITE(4,*)'# Time_Scheme'
     !WRITE(4,*)Time_Scheme
     
     !WRITE(4,*)'# HIGH_ORDER,CONSTR'
     !WRITE(4,*)HIGH_ORDER,CONSTR

     !WRITE(4,*)'# CFL,FroudeCap'
     !WRITE(4,*)CFL,FroudeCap

     !WRITE(4,*)'# DISP_TIME_LEFT'
     !WRITE(4,*)DISP_TIME_LEFT

! -- wet-dry
     !WRITE(4,*)'# MinDepth,MinDepthfrc'
     !WRITE(4,*)MinDepth,MinDepthfrc

! -- depth

      !WRITE(4,*)'# DEPTH'
      !WRITE(4,*)((DEPTH(I,J),I=1,Mloc),J=1,Nloc)
      !WRITE(4,*)'# DEPTHx'
      !WRITE(4,*)((DEPTHx(I,J),I=1,Mloc),J=1,Nloc)
      !WRITE(4,*)'# DEPTHy'
      !WRITE(4,*)((DEPTHy(I,J),I=1,Mloc),J=1,Nloc)
! variables
      !WRITE(4,*)'# U'
      !WRITE(4,*)((U(I,J),I=1,Mloc),J=1,Nloc)

      !WRITE(4,*)'# V'
      !WRITE(4,*)((V(I,J),I=1,Mloc),J=1,Nloc)

      !WRITE(4,*)'# U0'
      !WRITE(4,*)((U0(I,J),I=1,Mloc),J=1,Nloc)

      !WRITE(4,*)'# V0'
      !WRITE(4,*)((V0(I,J),I=1,Mloc),J=1,Nloc)

      !WRITE(4,*)'# Ubar'
      !WRITE(4,*)((Ubar(I,J),I=1,Mloc),J=1,Nloc)

      !WRITE(4,*)'# Vbar'
      !WRITE(4,*)((Vbar(I,J),I=1,Mloc),J=1,Nloc)

      !WRITE(4,*)'# ETA'
      !WRITE(4,*)((ETA(I,J),I=1,Mloc),J=1,Nloc)

      !WRITE(4,*)'# H'
      !WRITE(4,*)((H(I,J),I=1,Mloc),J=1,Nloc)

      !WRITE(4,*)'# MASK'
      !WRITE(4,*)((MASK(I,J),I=1,Mloc),J=1,Nloc)

      !WRITE(4,*)'# MASK9'
      !WRITE(4,*)((MASK9(I,J),I=1,Mloc),J=1,Nloc)

      !WRITE(4,*)'# MASK_STRUC'
      !WRITE(4,*)((MASK_STRUC(I,J),I=1,Mloc),J=1,Nloc)

      !WRITE(4,*)'# SPONGE_ON'
      !WRITE(4,*) SPONGE_ON
  
      !WRITE(4,*)'# SPONGE Width'
      !WRITE(4,*)Sponge_west_width,Sponge_east_width, &
!                 Sponge_south_width,Sponge_north_width
  
      !WRITE(4,*)'# SPONGE R and A'
      !WRITE(4,*)R_sponge,A_sponge

! show breaking
      !WRITE(4,*)'SHOW_BREAKING'
      !WRITE(4,*) SHOW_BREAKING
      IF(SHOW_BREAKING)THEN
      !WRITE(4,*)'# BREAKING AGE'
      !WRITE(4,*)((AGE_BREAKING(I,J),I=1,Mloc),J=1,Nloc)
      ENDIF
      

! wavemaker
! data for irregular wave case too large, recalculate when hotstart
!      IF(WAVEMAKER(1:6)=='WK_IRR')THEN
!       !WRITE(4,*)'# OMGN_IR'
!       !WRITE(4,*)(OMGN_IR(I),I=1,Nfreq)
!      !WRITE(4,*)'# Cm'
!      !WRITE(4,*)(((Cm(I,J,K),I=1,Mloc),J=1,Nloc),K=1,Nfreq)
!      !WRITE(4,*)'# Sm'
!      !WRITE(4,*)(((Sm(I,J,K),I=1,Mloc),J=1,Nloc),K=1,Nfreq)
!      ENDIF
!      IF(WAVEMAKER(1:6)=='WK_REG')THEN
!       !WRITE(4,*)'# D_gen,Beta_gen, rlamda'
!       !WRITE(4,*) D_gen,Beta_gen,rlamda
!      ENDIF
    
     CLOSE(4)

END SUBROUTINE !WRITE_HOTSTART_DATA

