        parameter(Nda=1000,Npt=1000)
        real TIME_COUPLING(Nda),U_COUPLING_WEST(Npt,Nda),
     &       V_COUPLING_WEST(Npt,Nda),
     &       Z_COUPLING_WEST(Npt,Nda),
     &       U_COUPLING_EAST(Npt,Nda),
     &       V_COUPLING_EAST(Npt,Nda),
     &       Z_COUPLING_EAST(Npt,Nda),
     &       U_COUPLING_SOUTH(Npt,Nda),
     &       V_COUPLING_SOUTH(Npt,Nda),
     &       Z_COUPLING_SOUTH(Npt,Nda),
     &       U_COUPLING_NORTH(Npt,Nda),
     &       V_COUPLING_NORTH(Npt,Nda),
     &       Z_COUPLING_NORTH(Npt,Nda)

! input parameters

! number of data
        Ndata = 100
! start point
        J_START_WEST = 20
        J_START_EAST = 0
        I_START_SOUTH = 0
        I_START_NORTH = 20
! number of nesting point
        Nwest=160
        Neast=0
        Nsouth=0
        Nnorth=0

        DO K=1,Ndata
         TIME_COUPLING(K)=(K-1.0)*1.0;
         ZZ=1.0*SIN(3.14*TIME_COUPLING(K)/100.0)
         UU=ZZ*SQRT(9.8/10.0)
         UUn=-UU
         DO I=1,Nwest
           Z_COUPLING_WEST(I,K)=ZZ*(I-1.)/(Nwest-1.)
           U_COUPLING_WEST(I,K)=UU*(I-1.)/(Nwest-1.)
           V_COUPLING_WEST(I,K)=0.0
         ENDDO
         DO I=1,Neast
           Z_COUPLING_EAST(I,K)=ZZ*(I-1.)/(Neast-1.)
           U_COUPLING_EAST(I,K)=UUn*(I-1.)/(Neast-1.)
           V_COUPLING_EAST(I,K)=0.0
         ENDDO
         DO I=1,Nsouth
           Z_COUPLING_SOUTH(I,K)=ZZ*(I-1.)/(Nsouth-1.)
           U_COUPLING_SOUTH(I,K)=0.0
         V_COUPLING_SOUTH(I,K)=UU*(I-1.)/(Nsouth-1.)
         ENDDO
         DO I=1,Nnorth
           Z_COUPLING_NORTH(I,K)=ZZ*(I-1.)/(Nnorth-1.)
           U_COUPLING_NORTH(I,K)=0.0
         V_COUPLING_NORTH(I,K)=UUn*(I-1.)/(Nnorth-1.)
         ENDDO

        ENDDO


        OPEN(1,FILE='coupling.txt')
         WRITE(1,*) 'nesting data'
         WRITE(1,*) 'Number of data:'
         WRITE(1,*) Ndata
         WRITE(1,*) 'Time series:'
         DO K=1,Ndata
           WRITE(1,*)TIME_COUPLING(K)
         ENDDO

! east
         WRITE(1,*) 'EAST boundary'
         WRITE(1,*) 'Num of points,','Start number J'
         WRITE(1,*) Neast, J_START_EAST
        IF(Neast.GT.0)THEN
         WRITE(1,*) 'U,V,Z data ...'
           DO K=1,Ndata
             WRITE(1,100)(U_COUPLING_east(I,K),I=1,Neast)
             WRITE(1,100)(V_COUPLING_east(I,K),I=1,Neast)
             WRITE(1,100)(Z_COUPLING_east(I,K),I=1,Neast)
           ENDDO
        ENDIF
! west
         WRITE(1,*) 'WEST boundary'
         WRITE(1,*) 'Num of points,','Start number J'
         WRITE(1,*) Nwest, J_START_WEST
        IF(Nwest.GT.0)THEN
         WRITE(1,*) 'U,V,Z data ...'
           DO K=1,Ndata
             WRITE(1,100)(U_COUPLING_WEST(I,K),I=1,Nwest)
             WRITE(1,100)(V_COUPLING_WEST(I,K),I=1,Nwest)
             WRITE(1,100)(Z_COUPLING_WEST(I,K),I=1,Nwest)
           ENDDO
          ENDIF
        
! south
         WRITE(1,*) 'SOUTH boundary'
         WRITE(1,*) 'Num of points,','Start number I'
         WRITE(1,*) Nsouth,I_START_south
        IF(Nsouth.GT.0)THEN
         WRITE(1,*) 'U,V,Z data ...'
           DO K=1,Ndata
             WRITE(1,100)(U_COUPLING_south(I,K),I=1,Nsouth)
             WRITE(1,100)(V_COUPLING_south(I,K),I=1,Nsouth)
             WRITE(1,100)(Z_COUPLING_south(I,K),I=1,Nsouth)
           ENDDO
         ENDIF
! north
         WRITE(1,*) 'NORTH boundary'
         WRITE(1,*) 'Num of points,','Start number I'
          WRITE(1,*) Nnorth, I_START_north
        IF(Nnorth.GT.0)THEN
         WRITE(1,*) 'U,V,Z data ...'
           DO K=1,Ndata
             WRITE(1,100)(U_COUPLING_north(I,K),I=1,Nnorth)
             WRITE(1,100)(V_COUPLING_north(I,K),I=1,Nnorth)
             WRITE(1,100)(Z_COUPLING_north(I,K),I=1,Nnorth)
           ENDDO
         ENDIF

100      format(999f12.3)

         CLOSE(1)
         END
