clear all
clf
dep1=load('tank.dat');
dx1=0.1752;
dy1=0.2128;
[n1 m1]=size(dep1);

x1=[0:m1-1]*dx1;
y1=[0:n1-1]*dy1-0.15;
[X1 Y1]=meshgrid(x1,y1);

dx=0.1;

x=[0:dx:45]';
y=[0:dx:26]';
x2=[0:dx:45];
y2=[0:dx:26];
[X Y]=meshgrid(x2,y2);

dep2=griddata(X1,Y1,dep1,X,Y);

nx=length(x);
ny=length(y);

h=zeros(ny,nx);

yc=13.0;
ys=yc;
xs=17;  %15.5
rs=3;
hs=.45;

x_ind=round(xs/dx)+1;
y_ind=round(ys/dx)+1;
r_ind=round(rs/dx);

h_shoal=zeros(nx,ny);
for i=x_ind-r_ind:x_ind+r_ind
   for j=y_ind-r_ind:y_ind+r_ind
      r_loc=sqrt( (x(i)-xs)^2 + (y(j)-ys)^2);
      if r_loc<rs
         h_shoal(i,j)=hs*(1-r_loc/rs);
      end
   end
end


y2=y2-13;
dep3=dep2-h_shoal';

% extend
dep4=zeros(ny,nx+50);
dep4(1:ny,1:50)=0.78;
dep4(1:ny,51:nx+50)=dep3(:,:);

%save -ASCII depth.txt dep4

%break
%pcolor(x2,y2,-dep3),shading flat

%save newdepth.mat dep3

cv=[-0.8:0.1:0.4];
[C,h]=contour(x2,y2,-dep3,cv,'k');
clabel(C,h,'manual')
xlabel('x (m)')
ylabel('y (m)')
grid

yg(1)=0;xg(1)=7.5;
yg(2)=0;xg(2)=13.0;
yg(3)=0;xg(3)=21.0;

yg(4)=5.;xg(4)=7.5;
yg(5)=5.;xg(5)=13.0;
yg(6)=5.;xg(6)=21.0;

yg(7)=0.;xg(7)=25.;
yg(8)=5.;xg(8)=25.;
yg(9)=10.;xg(9)=25.;

%xz=[7.5 21.0 13.0];
%yz=[0 0 5];

xv=[13 21 21];
yv=[0 0 -5];
hold on
plot(xg,yg,'o','LineWidth',2,'Markersize',12,'MarkerEdgeColor','k')
plot(xv,yv,'<','LineWidth',2,'Markersize',8,'MarkerEdgeColor','k')
text(xg(1)-1,yg(1)+0.9,'G1')
text(xg(2)-1,yg(2)+0.9,'G2')
text(xg(3)-1,yg(3)+0.9,'G3')
text(xg(4)-1,yg(4)+0.9,'G4')
text(xg(5)-1,yg(5)+0.9,'G5')
text(xg(6)-1,yg(6)+0.9,'G6')
text(xg(7)-1,yg(7)+0.9,'G7')
text(xg(8)-1,yg(8)+0.9,'G8')
text(xg(9)-1,yg(9)+0.9,'G9')

text(xv(1)-1,yv(1)-1.1,'ADV 1')
text(xv(2)-1,yv(2)-1.1,'ADV 2')
text(xv(3)-1,yv(3)-1.1,'ADV 3')

