clear all
clf
dep1=load('depth_analytical.txt');
dx1=0.1752;
dy1=0.2128;
[n1 m1]=size(dep1);

x1=[0:m1-1]*dx1;
y1=[0:n1-1]*dy1-0.15;
[X1 Y1]=meshgrid(x1,y1);

dx=0.1;

x=[0:dx:45]';
y=[0:dx:26]';
x2=[0:dx:45];
y2=[0:dx:26];
[X Y]=meshgrid(x2,y2);

%dep2=griddata(X1,Y1,dep1,X,Y);
dep2=dep1;

nx=length(x);
ny=length(y);

h=zeros(ny,nx);


y2=y2-13;
dep3=dep2;

% extend
dep4=zeros(ny,nx+50);
dep4(1:ny,1:50)=0.78;
dep4(1:ny,51:nx+50)=dep3(:,:);

save -ASCII depth_wkshop.txt dep4

break
%pcolor(x2,y2,-dep3),shading flat

%save newdepth.mat dep3

cv=[-0.8:0.1:0.4];
[C,h]=contour(x2,y2,-dep3,cv,'k')
%clabel(C,h,'manual')
xlabel('x (m)')
ylabel('y (m)')
grid
xz=[7.5 21.0 13.0];
yz=[0 0 5];
xv=[13 21 21];
yv=[0 0 -5];
hold on
plot(xz,yz,'o','LineWidth',2,'Markersize',12,'MarkerEdgeColor','k')
plot(xv,yv,'<','LineWidth',2,'Markersize',8,'MarkerEdgeColor','k')
text(xz(1)-1,yz(1)+0.9,'Gauge 1')
text(xz(2)-1,yz(2)+0.9,'Gauge 2')
text(xz(3)-1,yz(3)+0.9,'Gauge 3')
text(xv(1)-1,yv(1)-1.1,'ADV 1')
text(xv(2)-1,yv(2)-1.1,'ADV 2')
text(xv(3)-1,yv(3)-1.1,'ADV 3')

