%  plot_spectra.m
%
%  plot spectra for 4 gauges in lab cases.  Data file already loaded.

   t=data(:,1); eta(:,:)=data(:,2:5);
   
   figure(1), clf
   
   subplot(211)
   for ig=1:4,
       plot(t,eta(:,ig)+(ig-1)*20), hold on
   end
   ax=gca;
   ax.FontSize = 15;
   ax.FontName = 'Times';
   xlabel('$t$ (s)', 'interpreter', 'latex', 'fontsize', 15)
   ylabel('$\eta$ (mm)', 'interpreter', 'latex', 'fontsize', 15)
   
   %figure(2), clf
   
   subplot(212), clear p f
   for ig=1:4,
       [p(:,ig),f(:,ig)]=pwelch(eta(:,ig),1024,0,1024,200);
   end
   
   for ig=1:4,
       semilogy(f(:,ig),(10^(ig-1))*p(:,ig)), hold on
   end
   axis([0 10 1.0e-6 1.0e+5])
   ax=gca;
   ax.FontSize = 15;
   ax.FontName = 'Times';
   xlabel('$f$ (Hz)', 'interpreter', 'latex', 'fontsize', 15)
   ylabel('$P_{\eta\eta}$ (mm$^2$-s)', 'interpreter', 'latex', 'fontsize', 15)
   
   print -dpng bm4_spectra.png
   