%--------------------------------------------------------------------------
%
%  landslide_test.m
%
%  Perform comparison tests of landslide model results to data and/or other
%  models.
%
%  landslide_tests utilizes a variable "bm" which labels which benchmark is 
%  being considered, and a global array "model" which indicates which model 
%  or models are associated with the ongoing test.
%
%  The tests may compare a model or models to data, or a model to models.  
%  In any case, the first item identified (data or model) defines the 
%  reference time, and the remaining items are interpolated and then lagged 
%  to obtain a minimum RMS error relative to the first item.
%
%  Jim Kirby, 12/29/16
%--------------------------------------------------------------------------

%   global bmark model
   
%  Choose a benchmark to use

   disp('List of available benchmarks')

   disp('1: Solid slide, 1D')
   disp('2: Solid slide, 2D (Enet+Grilli)')
   disp('3: Solid slide, 2D (Liu et al)')
   disp('4: Submarine granular slide, 2D (Grilli et al)')
   disp('5: Subaerial granular slide, 2D (Viroulet et al)')
   disp('6: Subaerial granukar slide, 3D (Mohammed & Fritz)')
   disp('7: Field case: Port Valdez, AK, 1964') 
  
   bmark=input('Enter a benchmark number from the list above: ');
           
   if isempty(bmark),
        error('You didnt enter a benchmark number');
   end
  
   disp('model identifiers');
   
%  Model 0 refers to benchmark data

   disp('0: benchmark data');
   
%  Models 1,2,3, 10,21 are non-hydrostatic 
%  Models 14,15,16, 18, 19   are nondispersive
%  Models 4,5,6,7, 20 are Boussinesq models
%  Models 8, 9, 11 are navier-Stokes models
   disp('1: NHWAVE: 3D non-hydrostatic model, solid slide (UD, ODU, URI)');
   disp('2: NHWAVE: 3D non-hydrostatic model, viscous fluid slide (UD, UA)');
   disp('3: NHWAVE: 3D non-hydrostatic model, granular slide');
 
   disp('4: GloBous: Boussinesq model, linear');
   disp('5: GloBous: Boussinesq model, nonlinear');
   disp('6: BousClaw: standard dispersion');
   disp('7: BousClaw: pade dispersion');

   disp('8: TSUNAMI3D: Navier-Stokes (TAMUG)');
   disp('9: THETIS: Navier Stokes'); 
   disp('10: NHWAVE: 3D non-hydrostatic model, continuous density field');
   disp('11: THETIS: mu(I) viscosity');
   disp('12: L3SD');
   disp('13: 2LCMFLOW');
   disp('14: Alaska GI-L');
   disp('15: NHWAVE-solid, hydrostatic');
   disp('16: NHWAVE-granular, hydrostatic');
   disp('17: Landslide-HySEA');
   disp('18: FBSlide');
   disp('19: Lynett-NLSW');
   disp('20: Lynett-Bouss');
   disp('21: Lynett-MSE');

   

   model=input('Enter one or more model numbers (inside square brackets):');
   
%  The first model defines the reference time
          
   nmods=length(model);
   if nmods==0, error('no models were chosen'), end
 
%  Call appropriate subroutine for benchmark



     if bmark==2,
         [etamax,etamin,etavar,e_grilli,e_kirby] = bm2f(model);
     end
     
     if bmark==3,
         [etamax,etamin,etavar,e_grilli,e_kirby]=bm3(model);
     end

     if bmark==4,
         [etamax,etamin,etavar,e_grilli,e_kirby] = bm4f(model);
     end   

     if bmark==7,
         bm7(model);
     end  


    % 
          
   
   
   
   