function [T,om,tax,tridge]=wtf_f2(x,dt,model,imods,ig,bmark)
%
%    usage: [T,om,ax, tridge]=wtf_f2(x, dt, model, imods, ig, bmark))
%
%    where T is complex transform, om is frequency axis, ax is time axis,
%    and x is data.
%
%    compute the frequency domain wavelet transform for a sequence x of 
%    length ilen, with scaling over a specific range of real frequencies.
%
%    This first version uses the Morlet function as the only option.
%
%    James T. Kirby, July 12, 1991; scaled version July 19, 1991.  Revised
%    10/3/91 to make faster, add plotting.
%
%    Frequency range version 10/11/91, James T. Kirby
%
%    converting to matlab 4.0, 11/5/92
%
%    Version for landlside workshop, 1/5/17
%
%    wtf_f2 converted to give ridge as a function of frequency
%
     l102=log10(2);
     twopi_i=2*pi*i;
     twopi=2*pi;
%     om0=5;
%    
%    scale the length of the time series
%
     ilen=length(x);

     ilen=fix(ilen/2)*2;  % makes ilen even if it is odd to start with
     x=x(1:ilen);

     t1=1:1:ilen;  
     tp=t1/ilen;
     xp=fft(x,ilen);
%
%    define the array of dimensionless frequencies
%
     lim1=ilen/2;
     lim2=lim1+1;
     lim3=lim1-1;
     f(1)=0;
     f(2:lim1)=1:1:lim3;
     f(lim2:ilen)=-lim1:1:-1; 
%
%    determine range of f values and number of steps 
%
%     fmax=input(' Maximum frequency    : ');
     fmax=5;
%     ntot=input(' Number of frequency bands  : ');
     ntot=25;
%     ns=input(' Sampling rate : ');
     ns=1/dt;
%     om0=input(' Reference om0 : ');
     om0=5;
%     om0=15; %Just testing
%
%   plot the time series
%
     fignum=10*imods+ig;
     figure(fignum), clf
     
     tax=t1/ns;
     lim=max(abs(x));
     v1=[tax(1) tax(ilen) -lim lim];  v1
     subplot(211), plot(tax,x), % axis(v1);
     ax=gca;
     ax.FontSize = 15;
     ax.FontName = 'Times';
     title([' Model ' num2str(model(imods)) ', Gauge ' num2str(ig) ', Original Signal'], 'interpreter', 'latex', 'fontsize', 15)
     xlabel('$t(s)$', 'interpreter', 'latex', 'fontsize', 15),     
     ylabel(['$\eta_' num2str(ig) '$'], 'interpreter', 'latex', 'fontsize', 15)

     om=(1:ntot)*fmax/ntot;
     for j=1:ntot, F(:,j)=xp; end
%
%    loop over a values
%
     for j=1:ntot,  
         a=om0*ns/(twopi*ilen*om(j));
         sa=sqrt(a);
         w(:,j)=morletf(a,f,ilen,om0);
     end
%
%    compute wavelet transform as inverse FFT
%
     T=ifft(2*F.*w,ilen);
     v2=[tax(1) tax(ilen) 0 om(ntot)];

%    pchoice=menu(' Representation of wavelet transform to plot :','modulus','real part');
     pchoice=1;

     if(pchoice==1),

        subplot(2,1,2), contour(tax,om,abs(T)',8),axis(v2);
        ax=gca;
        ax.FontSize = 15;
        ax.FontName = 'Times';
        title('modulus of wavelet transform', 'interpreter', 'latex', 'fontsize', 15)
        xlabel('$t(s)$', 'interpreter', 'latex', 'fontsize', 15),
        ylabel('$\omega$', 'interpreter', 'latex', 'fontsize', 15),
     end
     if(pchoice==2),
        subplot(2,1,2), contour(tax,om,real(T)',8),axis(v2);
        ax=gca;
        ax.FontSize = 15;
        ax.FontName = 'Times';
        title(' real part of wavelet transform', 'interpreter', 'latex', 'fontsize', 15)
        xlabel('$t(s)$', 'interpreter', 'latex', 'fontsize', 15),
        ylabel('$\omega$', 'interpreter', 'latex', 'fontsize', 15), 
     end
     
     tridge=modefreqs4(T,om,tax);
     subplot(2,1,2), hold on, plot(tridge, om, 'r')
     
     eval(['print -dpng bm' num2str(bmark) '/bm' num2str(bmark) '_fig' num2str(fignum) '.png'])
       
