%
%   statistical_results_3.m
%
%   look at distribution of normalized elevatios maximums, elevation minimums, elevation excursions, and wave train variance for the various models, where normalization is w/r data values
%
%   This  version plots the values for a given model, with
%   the models classed as hydrodynamic types.
%
%   Models are categorized in terms of 4 hydrodynamic characterizations:

%   1 - hydrostatic
%   2 - weakly dispersive
%   3 - nonhydrostatic
%   4 - Navier-Stokes solvers

%   and 4 slide configurations:
%
%   1 - solid slide or analytic bottom motion
%   2 - viscous layer
%   3 - granular layer
%   4 - 3D multiphase
%
%   Error measures are:
%
%   1 - kirby - sqrt( sum(sum( (false-true)^2 ))/sum(sum( true^2 )) )
%   2 - grilli - sqrt( sum( false-true)^2 ))/(max(true)-min(true)), each
%                gage
%
%
%   dat file: stuff.mat
%
%   columns: 1=model, 2=hydro type, 3=slide type,
%            4-7=etamax, 8-11=etamin, 12-15=etavar, bm2,d=61
%            16-19=etamax, 20-23=etamin, 24-27=etavar, bm2,d=120
%            28-31=etamax, 32-35=etamin, 36-39=etavar, bm4,
%   (note that this implies a rewrite of stuff.mat, which does not have
%    columns 2 and 3 at present.)
%
%   J. Kirby, 1/8/17
%--------------------------------------------------------------------------

disp('List of available benchmarks')

   disp('1: Benchmark 2, Solid slide, d=061');
   disp('2: Benchmark 2, Solid slide, d=120');
   disp('3: Benchmark 4, Submarine granular slide');
   
disp('model identifiers');

   disp('0: benchmark data');
   disp('1: NHWAVE: 3D non-hydrostatic model, solid slide (UD, ODU, URI)');
   disp('2: NHWAVE: 3D non-hydrostatic model, viscous fluid slide (UD, UA)');
   disp('3: NHWAVE: 3D non-hydrostatic model, granular slide');
   disp('4: GloBous: Boussinesq model, linear');
   disp('5: GloBous: Boussinesq model, nonlinear');
   disp('6: BousClaw: standard dispersion');
   disp('7: BousClaw: pade dispersion');
   disp('8: TSUNAMI3D: Navier-Stokes (TAMUG)');
   disp('9: THETIS: Navier Stokes'); 
   disp('10: NHWAVE: 3D non-hydrostatic model, vontinuous density field');
   disp('11: THETIS: mu(I) viscosity');
   disp('12: L3SD');
   disp('13: 2LCMFLOW');
   disp('14: Alaska GI-L');
   disp('15: NHWAVE-solid, hydrostatic');
   disp('16: NHWAVE-granular, hydrostatic');
   
disp('Model hydrodynamic types');

   disp('1 - hydrostatic');
   disp('2 - weakly dispersive');
   disp('3 - nonhydrostatic');
   disp('4 - Navier-Stokes solvers');
   
disp('Slide types');
   disp('1 - solid slide or analytic bottom motion');
   disp('2 - viscous layer');
   disp('3 - granular layer');
   disp('4 - 3D multiphase');
   
%  specify which benchmarks to consider

   bmark=input('Enter list of benchmarks in square brackets: ');

%  specify which hydrodynamic model types to consider

%   htype=input('enter list of hydrodynamic model types in square brackets: ');
   
%  specify which slide types to consider

   stype=input('Enter list of slide types in square brackets: ');
   
%  number of benchmarks

   nb=length(bmark);
   
%  number of hydrodynamic types

%   nh=length(htype);
   
%  number of slide types

   ns=length(stype);
   
%  when plotting results, we need to specify symbols to identify model and
%  slide types.  For hydro-oriented plots, I'm going to use:
%           o=1
%           p=2
%           h=3  hexagram
%           *=4
%
   hsym=char('o','p','h','*');
%   
%  Slide types are going to be identified by color:
%           r=solid
%           g=viscous
%           b=granular
%           k=3D
%
   ssym=char('r','g','b','k');
%
%  define which columns in the error_data array are associated with which
%  gages, with entries 1,2,3 corresponding to benchmarks 1,2,3.

   g1m_cols=[4 16 28];  g1l_cols=[8 20 32]; g1v_cols=[12 24 36];
   g2m_cols=[5 17 29];  g2l_cols=[9 21 33]; g2v_cols=[13 25 37];
   g3m_cols=[6 18 30];  g3l_cols=[10 22 34]; g3v_cols=[14 26 38];
   g4m_cols=[7 19 31];  g4l_cols=[11 23 35]; g4v_cols=[15 27 39];
   
   load stuff
   
   models=stuff(:,1:3); s=size(models); nmods=s(1)-1,
   
   imod=0;
   lim1=0.75; lim2=nmods+.25
  
   figure(1),clf
   %  This plot is max runup, rundown as a function of model number
   
   plot([lim1 lim2], [0 0], 'k', 'LineWidth', 3), axis([lim1 lim2 -inf inf]), 
   hold on,
   plot([lim1 lim2], [1 1], '--k', 'LineWidth', 3)
   plot([lim1 lim2], [-1 -1], '--k', 'LineWidth', 3)
   set(gca,'xtick',1:nmods);
   ax=gca;
   ax.FontSize = 15;
   ax.FontName = 'Times';
   xlabel('Model number', 'interpreter', 'latex', 'fontsize', 20)
   ylabel('$\eta_{max}/\eta_{max,observed}, -\eta_{min}/\eta_{min,observed}$', ...
          'interpreter', 'latex', 'fontsize', 20)

   figure(2), clf
   %  This plot is max runup, rundown as a function of model number
   
   plot([lim1 lim2], [0 0], 'k', 'LineWidth', 3), axis([lim1 lim2 -inf inf]), 
   hold on
   plot([lim1 lim2], [1 1], '--k', 'LineWidth', 3)
   plot([lim1 lim2], [-1 -1], '--k', 'LineWidth', 3)
   set(gca,'xtick',1:nmods);
   ax=gca;
   ax.FontSize = 15;
   ax.FontName = 'Times';
   xlabel('Model number', 'interpreter', 'latex', 'fontsize', 20)
   ylabel('$\eta_{max}-\eta_{min}, -\sqrt{var(\eta)}$', 'interpreter', 'latex', 'fontsize', 20)


   %  Reference values from data

   g1m_ref=stuff(1,g1m_cols); g2m_ref=stuff(1,g2m_cols); 
   g3m_ref=stuff(1,g3m_cols); g4m_ref=stuff(1,g4m_cols);
   g1l_ref=stuff(1,g1l_cols); g2l_ref=stuff(1,g2l_cols); 
   g3l_ref=stuff(1,g3l_cols); g4l_ref=stuff(1,g4l_cols);
   g1v_ref=stuff(1,g1v_cols); g2v_ref=stuff(1,g2v_cols); 
   g3v_ref=stuff(1,g3v_cols); g4v_ref=stuff(1,g4v_cols);
   g1h_ref=g1m_ref-g1l_ref; g2h_ref=g2m_ref-g2l_ref; 
   g3h_ref=g3m_ref-g3l_ref; g4h_ref=g4m_ref-g4l_ref;

   %  Outer loop is over hydrodynamic model types
   for ih=1:4,
       %  loop over all models and identify whether they are of this model
       %  type
       for mindex=2:nmods+1,
           if models(mindex,2)==ih,
               %  Do stuff for this model
               imod=imod+1;
               s=models(mindex,3);
               sym=[hsym(ih), ssym(s)];
               ib=0; is=0;
               %  Next, loop over benchmarks
               for ib=1:nb,
                  bm=bmark(ib);
             %     g1m=g1m_cols(bm); g2m=g2m_cols(bm); g3m=g3m_cols(bm); g4m=g4m_cols(bm);
                  %  and over slide types
                  for is=1:ns,
                    % Is the slide type for this model in the list
                    % of desired types?  If so, plot symbol for this model
                    if any(s==stype),
  
                       if g1m_ref(ib)~=0,
                         g1m=stuff(mindex,g1m_cols(ib) ); g1m(g1m==0)=NaN;
                         g1l=stuff(mindex,g1l_cols(ib) ); g1l(g1l==0)=NaN;
                         g1v=stuff(mindex,g1v_cols(ib) ); g1v(g1v==0)=NaN;
                         g1h=g1m-g1l; g1h(g1h==0)=NaN;
                         figure(1)
                         plot(imod, g1m./g1m_ref(ib), sym, ...
                              imod, -g1l./g1l_ref(ib), sym, 'MarkerSize', 15)
                         figure(2)
                         plot(imod, g1h./(g1m_ref(ib)-g1l_ref(ib)), sym, ...
                              imod, -sqrt(g1v./g1v_ref(ib)), sym, 'MarkerSize', 15)
                       end
        
                       if g2m_ref(ib)~=0,
                         g2m=stuff(mindex,g2m_cols(ib) ); g2m(g2m==0)=NaN;
                         g2l=stuff(mindex,g2l_cols(ib) ); g2l(g2l==0)=NaN;
                         g2v=stuff(mindex,g2v_cols(ib) ); g2v(g2v==0)=NaN;
                         g2h=g2m-g2l; g2h(g2h==0)=NaN;
                         figure(1)
                         plot(imod, g2m./g2m_ref(ib), sym, ...
                              imod, -g2l./g2l_ref(ib), sym, 'MarkerSize', 15)
                         figure(2)
                         plot(imod, g2h./(g2m_ref(ib)-g2l_ref(ib)), sym, ...
                              imod, -sqrt(g2v./g2v_ref(ib)), sym, 'MarkerSize', 15)
                       end

                       if g3m_ref(ib)~=0,
                         g3m=stuff(mindex,g3m_cols(ib) ); g3m(g3m==0)=NaN;
                         g3l=stuff(mindex,g3l_cols(ib) ); g3l(g3l==0)=NaN;
                         g3v=stuff(mindex,g3v_cols(ib) ); g3v(g3v==0)=NaN;
                         g3h=g3m-g3l; g3h(g3h==0)=NaN;
                         figure(1)
                         plot(imod, g3m./g3m_ref(ib), sym, ...
                              imod, -g3l./g3l_ref(ib), sym, 'MarkerSize', 15)
                         figure(2)
                         plot(imod, g3h./(g3m_ref(ib)-g3l_ref(ib)), sym, ...
                              imod, -sqrt(g3v./g3v_ref(ib)), sym, 'MarkerSize', 15)
                       end

                       if g4m_ref(ib)~=0,
                         g4m=stuff(mindex,g4m_cols(ib) ); g4m(g4m==0)=NaN;
                         g4l=stuff(mindex,g4l_cols(ib) ); g4l(g4l==0)=NaN;
                         g4v=stuff(mindex,g4v_cols(ib) ); g4v(g4v==0)=NaN;
                         g4h=g4m-g4l; g4h(g4h==0)=NaN;
                         figure(1)
                         plot(imod, g4m./g4m_ref(ib), sym, ...
                              imod, -g4l./g4l_ref(ib), sym, 'MarkerSize', 15)
                         figure(2)
                         plot(imod, g4h./(g4m_ref(ib)-g4l_ref(ib)), sym, ...
                              imod, -sqrt(g4v./g4v_ref(ib)), sym, 'MarkerSize', 15)
                       end


                    end
                  end
               end
           end
       end
   end

   figure(1), print -djpeg heights1.jpg
   figure(2), print -djpeg heights2.jpg





