%--------------------------------------------------------------------------
%
function  bm7(model);
%
%  Perform comparisons for benchmark 7.
%
%  J. Kirby, 12/21/16; Cheng Zhang,1/6/17
%
%  Required format:
%  All data are in bm7_mn.mat, where n is model order.
%  For case with two slides together, the mat file should include data which 
%  has 3 columns of t,light,hotel, or 5 columns of t,light,hotel,p37,p38, 
%  and hmax,inundation,lonm,latm.
%  For cases with two slides separately, the mat file should include
%  data_HPV,data_SBM which has 3 columns of t,light,hotel, or 5 columns of 
%  t,light,hotel,p37,p38, and hmax_HPV,hmax_SBM,inundation,lonm,latm .
%--------------------------------------------------------------------------

%   global bmark model
   
   nmods=length(model); bmark=7;

%  Performing comparisons for nmods models, where model_0 does not contain
%  any benchmark data

%  plot gauge data. It is assumed that data file has t,g1,g2 stored for 
%  gauge=2 and has t,g1,g2,g3,g4 stored for gauge=4

   clear data data_HPV data_SBM hmax hmax_HPV hmax_SBM inundation lonm latm
   
   figure(1), clf;
   set(gcf,'outerposition',get(0,'screensize'));
   
   gname = {'Navigation Light','Hotel','Point 37','Point 38'};
   
   mdllg=[];mdlname={};
   icount=0;
   pileup=[20,1,15,4];
   for imods=1:nmods
     clear data data_HPV data_SBM
     filename=['formatted_results/bm7_m' num2str(model(imods)) '.mat' ];
     load(filename);
     if exist('data') || exist('data_HPV')
       if exist('data') %case for two slides together
         sld(imods)=1;
         if length(data(1,:))==3
           gauge=2;%record elevations at Hotel & Navigation Light
         else
           gauge=4;%record elevations at Hotel, Navigation Light, Points 37 & 38
         end    
       else %cases for two slides separately
         sld(imods)=2;
         if length(data_HPV(1,:))==3
           gauge=2;%record elevtions at Hotel & Navigation Light
         else
           gauge=4;%record elevtions at Hotel, Navigation Light, Points 37 & 38
         end 
         % pad ends of shorter arrays with 0's
         s_HPV=size(data_HPV);s_SBM=size(data_SBM);s1=max(s_HPV(1),s_SBM(1));
         data_HPV=[data_HPV;zeros(s1-s_HPV(1),s_HPV(2))];
         data_SBM=[data_SBM;zeros(s1-s_SBM(1),s_SBM(2))];
         data=data_HPV+data_SBM;% superimpose wave elevations (HPV64+SBM64)
       end
       %  find when the wave reach navigation light

%        tindex=find(diff(data(:,2))>0.001);
%        t0=data(tindex(1),1);
       t0=1;
       %  plot raw data to check for scaling inconsistencies
       for igg=1:gauge
         subplot(220+igg)
         plot([0 20],[icount*pileup(igg) icount*pileup(igg)],'--k')
         if igg==2
           wg=plot(data(:,1)-t0+1, data(:,igg+1)+icount*pileup(igg));
         else
           plot(data(:,1)-t0+1, data(:,igg+1)+icount*pileup(igg))
         end
         title(gname{igg},'FontSize',12)
%          if igg == 2
%            ylim([0,1])
%          elseif igg == 3
%            ylim([-5,5])
%          elseif igg == 4
%            ylim([0,5])
%          end
         xlim([0,20])
         xlabel('Time after failure (minute)')
         ylabel('\eta (m)')
         hold on
       end
       for igg=1:gauge
         subplot(220+igg)
         plot([0 20],[icount*pileup(igg) icount*pileup(igg)],'--k')
       end
       mdllg=[mdllg wg];
       mdlname=[mdlname,['Model ' num2str(model(imods))]];
       icount=icount+1;
     end
   end
   if nmods>1
     l1=legend(mdllg, mdlname);
     legend('boxoff')
     set(l1,'Box','off');
   end
   suptitle(['Benchmark 7:  Models ' num2str(model) ', Surface elevations'])
   
   print -djpeg bm7/bm7_Gauges.jpg
   
   
%  show inundation map (max runup map)

   lon=load('bm7/model_0/valdez.bathymetry.long');
   lat=load('bm7/model_0/valdez.bathymetry.latg');
   bathymetry=load('bm7/model_0/valdez.1964.bathymetry');
   InundationLine_1964=shaperead('bm7/model_0/InundationLine.shp');
   InundationLineIslands1964=shaperead('bm7/model_0/InundationLineIslands.shp');
   InundationLineFirstWave=shaperead('bm7/model_0/InundationLineFirstWave.shp');
   McKinley=shaperead('bm7/model_0/McKinley_St.shp');
   
   Hotel_lon=-146.26701;
   Hotel_lat=61.115823;

   NavigationalLight_lon=-146.652749;
   NavigationalLight_lat=61.081169;
   
   figure(2), clf
   set(gcf,'outerposition',get(0,'screensize'));
   iwidth=1;iheight=1;icount=0;
   for imods=1:nmods
     clear hmax hmax_HPV hmax_SBM lonm latm
     filename=['formatted_results/bm7_m' num2str(model(imods)) '.mat' ];
     load(filename);
     if exist('hmax') || exist('hmax_HPV')
       icount=icount+1;
     end
   end
   iwidth=floor((icount-0.1)/2)+1;
   if icount==1
     iheight=1;
   else
     iheight=2;
   end

   icount=0;
   for imods=1:nmods
     clear hmax hmax_HPV hmax_SBM lonm latm
     filename=['formatted_results/bm7_m' num2str(model(imods)) '.mat' ];
     load(filename);
     if exist('hmax') || exist('hmax_HPV')
       icount=icount+1;
       if sld(imods)==2%cases for two slides separately
         hmax=hmax_HPV+hmax_SBM;
       end
       hmax(hmax<=10e-6)=nan;
       subplot(iwidth,iheight,icount)
       pcolor(lonm, latm, hmax); shading flat, colorbar  
       caxis([0 20])
       hold on
       contour(lon, lat, bathymetry,[0 0],'k')    %Bathymetry on which the slide is moving, meters
       title(['Model ' num2str(model(imods))],'FontSize',12)
       set(gca,'DataAspectRatio',[3 1 1])
     end
   end
   suptitle(['Benchmark 7:  Models ' num2str(model) ', Maximum runup map'])
   
   print -djpeg bm7/bm7_Maximum_runup.jpg
   
%  show inundation mapping near McKinley Street and Valdez Hotel

   figure(3), clf
   set(gcf,'outerposition',get(0,'screensize'));
   
   [c,h]=contour(lon, lat, bathymetry,[0 0],'k');    %Bathymetry on which the slide is moving, meter
   hold on
   ic=plot(InundationLine_1964.X, InundationLine_1964.Y,'-g'); 
   for i=1:7
     plot(InundationLineIslands1964(i).X, InundationLineIslands1964(i).Y,'-g') 
   end
   for i=1:3
     fw=plot(InundationLineFirstWave(i).X, InundationLineFirstWave(i).Y,'-r');
   end
   mk=plot(McKinley.X, McKinley.Y,'-k','LineWidth',2); 
   vh=plot(Hotel_lon, Hotel_lat, '^r','MarkerFaceColor','r');
   mdllg=[h, ic, fw, mk, vh];
   mdlname={'Shoreline after the HPV64 slide', 'Observed extent of inundation', 'Debris line from the 1st wave', 'McKinley Street','Valdez Hotel'};
   for imods=1:nmods
     clear inundation
     filename=['formatted_results/bm7_m' num2str(model(imods)) '.mat' ];
     load(filename);
     if exist('inundation')
       h1=plot(inundation(:,1),inundation(:,2),'--','LineWidth',2);
       mdllg=[mdllg h1];
       mdlname=[mdlname,['Inundation results from model ' num2str(model(imods))]];
     end
   end
   hold off
   legend(mdllg, mdlname)
   axis([-146.31 -146.23 61.105 61.125])
   set(gca,'PlotBoxAspectRatio',[1 cosd(61.1) 1])
   title(['Benchmark 7:  Models ' num2str(model) ', Inundation line'])

   print -djpeg bm7/bm7_Inundation_line.jpg
   
   % show tables for wave elevation at certain points in Plafker report 
   
   figure(4), clf
   set(gcf,'outerposition',get(0,'screensize'));
   
   icount=[];
   for imods=1:nmods
     clear tablem
     filename=['formatted_results/bm7_m' num2str(model(imods)) '.mat' ];
     load(filename);
     if exist('tablem')
       icount=[icount,model(imods)];
     end
   end
   m=25;n=length(icount);
   
   if n~=0
     Plafker=[51;6;21;37;18;23;11;17;23;10;15;15;20;20;24;12;23;11;9;10;9;18;12;11;27];
     column_name=['Lat. (deg)  ';'Lon. (deg)  ';'Plafker (m) '];
     for i=icount
       if floor(log10(i))+1==1;
         column_name=[column_name;['Model ' num2str(i) ' (m) ']];
       else
         column_name=[column_name;['Model ' num2str(i) ' (m)']];
       end  
     end
     row_name=strcat(num2str((1:m)'));
     
     icount=0;
     for imods=1:nmods
       clear tablem
       filename=['formatted_results/bm7_m' num2str(model(imods)) '.mat' ];
       load(filename);
       if exist('tablem')
         icount=icount+1;
         if icount==1
           tablet=[tablem(:,1:2),Plafker,tablem(:,3)];
         else
           tablet=[tablet,tablem(:,3)];
         end
       end
     end
     tab=uitable(gcf,'Data',tablet,'Position',[200 250 1500 550],'Columnname',column_name,'Rowname',row_name);
     tab.FontSize = 10;
   end
   
    