%--------------------------------------------------------------------------
%
function  [etamax,etamin,etavar,e_grilli,e_kirby] = bm4f(model);
%
%  Perform comparisons for benchmark 4.
%
%  The only case here is case1, corresponding to test t17.
%
%  This version, edited on 12/19/17, calculates the ridge as a function of
%  frequency rather than time.
%
%  J. Kirby, 12/30/16, 1/4/17, 12/19/17, 12/20/17, 1/8/18, 1/15/18
%
%--------------------------------------------------------------------------

   nmods=length(model); bmark=4;

%  Performing comparisons for nmods models, where model_0 indicates the
%  benchmark data.

   clear dat, clear data
   
%  load raw data.  It is assumed that data file has t,g1,g2,g3,g4 stored
%  column-wise.  Time steps may be different.

%  Find longest array first.

   smax=0;

   for imods=1:nmods,
       filename=['formatted_results/bm4_m' num2str(model(imods)) '_case1.mat' ];
       load(filename); s=size(data); smax=max(smax,s(1)); len(imods)=s(1); 
       clear data
   end
   
%  now, load the data, pad ends of shorter arrays with NaN's
   
   for imods=1:nmods,
       filename=['formatted_results/bm4_m' num2str(model(imods)) '_case1.mat' ];
       load(filename); s=size(data);
       dat(imods,1:s(1),1:s(2))=data;
       if s(1) < smax,
           dat(imods,s(1)+1:smax,1:s(2))=NaN;
       end
   end  
   
%  Find time of occurrence of maximum elevation at gauge 2 for each model,
%  shift time in that model so that this peak is at time 0.  This is
%  supposed to line up the peaks at gauge 2 for all models being compared.

   for imods=1:nmods,
       %  Find index for maximum elevation for gage 2 (minimum if model 16)
       if any(model==16),
           [Y,I]=sort(dat(imods,1:len(imods),3), 'ascend');
       else
           [Y,I]=sort(dat(imods,1:len(imods),3), 'descend');
       end
       t0=dat(imods,I(1),1);
       dat(imods,1:len(imods),1)=dat(imods,1:len(imods),1)-t0;
   end
   
 %  plot raw data to check for scaling inconsistencies
       
   figure(1), clf;

   for imods=1:nmods,
       subplot(411), plot(dat(imods,1:len(imods),1), dat(imods,1:len(imods),2)), 
                     axis([-3 4 -1 1]), 
                     hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
       subplot(412), plot(dat(imods,1:len(imods),1), dat(imods,1:len(imods),3)), 
                     axis([-3 4 -1 1]),
                     hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
       subplot(413), plot(dat(imods,1:len(imods),1), dat(imods,1:len(imods),4)), 
                     axis([-3 4 -1 1]),
                     hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
       subplot(414), plot(dat(imods,1:len(imods),1), dat(imods,1:len(imods),5)), 
                     axis([-3 4 -1 1]),
                     hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
   end
   
   subplot(411), ylabel('$\eta_1$ (mm)', 'interpreter', 'latex', 'fontsize', 20)
   title(['Benchmark ' num2str(bmark) ':  Models ' num2str(model) ], 'interpreter', 'latex', 'fontsize', 20)
   subplot(412), ylabel('$\eta_2$ (mm)', 'interpreter', 'latex', 'fontsize', 20)
   subplot(413), ylabel('$\eta_3$ (mm)', 'interpreter', 'latex', 'fontsize', 20)
   subplot(414), ylabel('$\eta_4$ (mm)', 'interpreter', 'latex', 'fontsize', 20)
   xlabel('$t$(s)', 'interpreter', 'latex', 'fontsize', 20),
   
   print -dpng bm4/bm4_fig1.png     

%  Everything look OK?  Now, interpolate 2nd, third, etc models onto time
%  step of first model.  Reference values are determined relative to first 
%  model. Replot figure 1 to make sure new times make sense.    The fit is
%  for the range -3 < t < 4

   
%  Truncate the time values to the range -3 < t < 4, determine
%  corresponding indices.  This is based on using whichever model was
%  entered as the first entry in the model array.

   N=len(1); ng = s(2)-1;
   dt=dat(1,2,1)-dat(1,1,1); tref=dat(1,1:N,1);
   tref=tref(tref<=4);  N1=length(tref); iend(1)=N1;
   tref=tref(tref>=-3); N2=length(tref); istart(1)=N1-N2+1;
   datref(:,:)=dat(1,istart(1):iend(1),2:s(2));

   figure(2), clf
   
   subplot(411), plot(tref,datref(:,1)), 
                     axis([-3 4 -1 1]), hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
   subplot(412), plot(tref,datref(:,2)), 
                     axis([-3 4 -1 1]),hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
   subplot(413), plot(tref,datref(:,3)), 
                     axis([-3 4 -1 1]),hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
   subplot(414), plot(tref,datref(:,4)), 
                     axis([-3 4 -1 1]),hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
                       
   subplot(411), ylabel('$\eta_1$ (mm)', 'interpreter', 'latex', 'fontsize', 20)
   title(['Benchmark 4: Models ' num2str(model) ], 'interpreter', 'latex', 'fontsize', 20)
   subplot(412), ylabel('$\eta_2$ (mm)', 'interpreter', 'latex', 'fontsize', 20)
   subplot(413), ylabel('$\eta_3$ (mm)', 'interpreter', 'latex', 'fontsize', 20)
   subplot(414), ylabel('$\eta_4$ (mm)', 'interpreter', 'latex', 'fontsize', 20)
   xlabel('$t$(s)', 'interpreter', 'latex', 'fontsize', 20),     
   
%  Statistics for reference model

   etamax(1,:)=max(datref), etamin(1,:)=min(datref), etavar(1,:)=var(datref),   
   
   datsave(1,:,:)=datref;
   
%  Repeat if there is more than one model, using the tref time axis from
%  model(1).

   if nmods > 1,
   
      for imods=2:nmods,
          imods
   %       
   %  construct the time and data file for model(imods) using the reference
   %  time constructed from the observed model 0 data (or whatever model is
   %  the reference).
   %
         t1=dat(imods,1:len(imods),1);
         dat1(:,:)=dat(imods,1:len(imods),2:s(2));
         dat1(isnan(dat1))=0.;
   %      
   %  interpolate the data onto the reference time axis
   %
         dat1n=interp1(t1,dat1,tref); dat1n(isnan(dat1n))=0;
   %
   %  Plot the interpolated time series
   %      
         subplot(411), plot(tref,dat1n(:,1)), 
                     
         subplot(412), plot(tref,dat1n(:,2)), 
                     
         subplot(413), plot(tref,dat1n(:,3)), 
                     
         subplot(414), plot(tref,dat1n(:,4)), 
                     
   %  Statistics for model(imods)

         etamax(imods,:)=max(dat1n), etamin(imods,:)=min(dat1n), etavar(imods,:) = ...
             var(dat1n),
         
      %  Grilli error for each gage for model(imods) relative to model(1)
      
         for ig=1:4,
             e_grilli(imods,ig) = sqrt(var(dat1n(:,ig)-datref(:,ig)))/...
                 (etamax(1,ig)-etamin(1,ig));
         end
         
         e_grilli(imods,:)
         
      %  A different global error
      
         num = sum(var( dat1n(:,ig) - datref(:,ig) ));
         den = sum(var( datref(:,ig) ) );
         e_kirby(imods) = sqrt(num/den);
         
         e_kirby(imods)
   
         datsave(imods,:,:)=dat1n;
      end
   end
          print -dpng bm4/bm4_fig2.png

   wavT=input('wavelet analysis? Yes=1: ');
   
   if wavT==1,
       
       %  We are going to construct the wavelet transform for each model
       %  being considered, and then we are going to look at the dominant
       %  frequencies.  
       
       %  It is good to have the data padded by a number of zeros at either
       %  end, to eliminate wrap-around.
       
       N=length(tref); ts=tref(1); te=tref(N); 
       tpad=[ ts+dt*(-floor(N/2):1:-1) tref te+dt*(1:floor(N/2))];
       
       Npad=length(tpad)
             
       for imods=1:nmods,
           
           dtemp=squeeze(datsave(imods,:,:));
           dpad=[zeros(floor(N/2),4); dtemp; zeros(floor(N/2),4)];
           
           Nd=length(dpad)
           
           for ig=1:ng,
       %        
       %  Compute wavelet transform for each model and gauge.  Note, om
       %  here is regular frequency, not angular frequency.
       %    
              x=dpad(:,ig);
              Nx = length(x)
              [T,om,tax,tridge]=wtf_f2(x,dt,model,imods,ig,bmark);
              Ntax = length(tax)
              WT(imods,ig,:,:)=T;
              tmax(imods,ig,:)=tridge;
           end
       end
       
    %
    %  Compute the group velocity as a function of frequency
    %
       omega=2*pi*om;  h=0.332;  g=9.80621;
       k=wvnum_omvec(h,omega,g);
       cg=(omega./(2*k)).*( 1 + (2*k*h)./sinh(2*k*h) );
       c = omega./k;
       
       figure(30), clf
       plot(om,cg)
       
       tplot=tpad(1:Ntax);
    %
    %  Compare the data and model transforms and ridge frequencies.
    %  
       v2=[tpad(1) tpad(length(tax)) 0 om(length(om))];
       t_offset=tplot(1)-tax(1);
       
       for ig=1:4,
           
           fignum=2+ig;
           figure(fignum), clf
           
           T1=squeeze(WT(1,ig,:,:)); 
        %
        %  tridge1(:,ig) saves arrival times at gauge ig as a function of
        %  frequency
           
           tridge1_tmp = squeeze(tmax(1,ig,:))+t_offset;
        %  
        %  ignore ridge values for frequencies < 0.5 Hz or > 2 Hz
        %
           tridge1_tmp(om<0.5) = NaN;
           tridge1_tmp(om>2.0) = NaN;
           tridge1(:,ig)=tridge1_tmp;
           
           contour(tplot,om,abs(T1)',8), axis(v2), hold on,
           plot(squeeze(tridge1(:,ig)), om, 'r', 'Linewidth', 3)
           ax=gca;
           ax.FontSize = 15;
           ax.FontName = 'Times';
           title(['Models ' num2str(model) ', Gauge ' num2str(ig) ], ...
               'interpreter', 'latex', 'fontsize', 20)
           xlabel('$t$(s)', 'interpreter', 'latex', 'fontsize', 20),
           ylabel('$f$(Hz)', 'interpreter', 'latex', 'fontsize', 20),
           
           hold on
           
           if nmods>1,
               for imods = 2:nmods,
                   T2=squeeze(WT(imods,ig,:,:)); 
                   
                   tridge2_tmp=squeeze(tmax(imods,ig,:))+t_offset;
                   tridge2_tmp(om<0.5) = NaN;
                   tridge2_tmp(om>2.0) = NaN;
                %  
                %  tridge2(:,ig,imods) saves the calculated arrival times
                %  for each of the models being tested
                %
                   tridge2(:,ig,imods-1)=tridge2_tmp;
                   
                   
                   contour(tplot,om,abs(T2)',8, '--');
                   plot(squeeze(tridge2(:,ig,imods-1)), om, 'b', 'Linewidth', 3)
               end
           end
           
        %
        %  Now, calculate the theoretical arrival time based on the actual
        %  group velocity, starting from the measured data at gauge 1
        
           if ig == 1, 
               tridge3 = tridge1(:,1);
               tridge4 = tridge3;
           else
               tridge3 = tridge1(:,1) + ( (ig-1)./cg )';
               tridge4 = tridge1(:,1) + ( (ig-1)./c )';
           end
           plot(tridge3, om, 'r--', tridge4, om, 'r:', 'Linewidth', 3)
           
        %
        %  Print results
        %
           
           eval(['print -dpng bm' num2str(bmark) '/bm' num2str(bmark) '_fig' ...
               num2str(fignum) '.png'])
       end
    %
    %  Now, plot the wavelet correlations
    
       if nmods > 1,
           
           for ig=1:4,
               fignum=6+ig;
               figure(fignum),clf
               
               for imods=2:nmods,
               
                  T2=squeeze(WT(imods,ig,:,:)); 
                  tridge2(:,ig)=squeeze(tmax(imods,ig,:))+t_offset;
            %
            %  wavelet correlation conj(T(2))/conj(T(1))
            %
                  [T3R,T3I]=wavelet_corr(T1,T2,tax,om);
                  v11=[.25 .5 .75 1 2];  v12=[-2 -1 -.75 -.5 -.25]; v13=0;
                  subplot(211), contour(tplot,om,T3R',v11), hold on,
                         contour(tplot,om,T3R',v12, '--'),
                         contour(tplot,om,T3R',v13, 'k', 'LineWidth', 2),
                         plot(squeeze(tridge1(:,ig)), om, 'r')
                         plot(squeeze(tridge2(:,ig)), om, 'b')
                  ax=gca;
                  ax.FontSize = 15;
                  ax.FontName = 'Times';
                  title(['Wavelet correlation (real), Models ' num2str(model) ...
                      ', Gauge' num2str(ig) ], 'interpreter', 'latex', 'fontsize', 20)
                  ylabel('$\omega$', 'interpreter', 'latex', 'fontsize', 20),
           
                  subplot(212), contour(tplot,om,T3I',v11), hold on,
                         contour(tplot,om,T3I',v12, '--'),
                         contour(tplot,om,T3I',v13, 'k', 'LineWidth', 5),
                         plot(squeeze(tridge1(:,ig)), om, 'r')
                         plot(squeeze(tridge2(:,ig)), om, 'b')
                  ax=gca;
                  ax.FontSize = 15;
                  ax.FontName = 'Times';
                  title(['Wavelet correlation (imag), Models ' num2str(model) ...
                    ', Gauge ' num2str(ig) ], 'interpreter', 'latex', 'fontsize', 20)
                  ylabel('$\omega$', 'interpreter', 'latex', 'fontsize', 20),
                  xlabel('$t(s)$', 'interpreter', 'latex', 'fontsize', 20)
               end
           
  %             eval(['print -dpng bm' num2str(bmark) '/bm' num2str(bmark) '_fig' ...
  %                  num2str(fignum) '.png'])
           end
       end      
  end


