function [etamax,etamin,etavar,e_grilli,e_kirby] = bm2(model);
%
%  Perform comparisons for benchmark 2.
%
%  J. Kirby, 12/30/16, 1/4/17, 1/15/18
%
%--------------------------------------------------------------------------

   nmods=length(model); bmark=2;
   
   depth=input('Enter initial depth of submergence: ','s');

%  Performing comparisons for nmods models, where model_0 indicates the
%  benchmark data

   clear dat, clear data
   
%  load raw data.  It is assumed that data file has t,g1,g2,g3,g4 stored
%  column-wise.  Time steps may be different.

%  Find longest array first.

   smax=0;

   for imods=1:nmods,
       filename=['formatted_results/bm2_m' num2str(model(imods)) '_d' depth '.mat' ];
       load(filename); s=size(data); smax=max(smax,s(1));  len(imods)=s(1); clear data
   end
   
%  now, load the data, pad ends of shorter arrays with 0's
   
   for imods=1:nmods,
       filename=['formatted_results/bm2_m' num2str(model(imods)) '_d' depth '.mat' ];
       load(filename); s=size(data);
       dat(imods,1:s(1),1:s(2))=data;
       if s(1) < smax,
           dat(imods,s(1)+1:smax,1:s(2))=0;
       end
   end
   
%  Find time of occurrence of maximum elevation at gauge 2 for each model,
%  shift time in that model so that this peak is at time 0.  This is
%  supposed to line up the peaks at gauge 2 for all models being compared.
%  For nondispersive cases, line up first negative at gage 1.

   for imods=1:nmods,
       if ( any(model==14) | any(model==15) | any(model==18) | any(model==19) ),
           %  Find index for occurance of minimum at gage 1
           [Y,I]=sort(dat(imods,1:len(imods),2), 'ascend');
           t0=dat(imods,I(1),1);
           dat(imods,1:len(imods),1)=dat(imods,1:len(imods),1)-(t0+1.75);
       else
           %  Find index for maximum elevation for gage 2
          [Y,I]=sort(dat(imods,1:len(imods),3), 'descend');
          t0=dat(imods,I(1),1);
          dat(imods,1:len(imods),1)=dat(imods,1:len(imods),1)-t0;
       end
   end
            
%  plot raw data to check for scaling inconsistencies
       
   figure(1), clf;

   for imods=1:nmods,
       subplot(411), plot(dat(imods,1:len(imods),1), dat(imods,1:len(imods),2)), 
                     axis([-2 3 -25 25]), hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
       subplot(412), plot(dat(imods,1:len(imods),1), dat(imods,1:len(imods),3)), 
                     axis([-2 3 -25 25]),hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
       subplot(413), plot(dat(imods,1:len(imods),1), dat(imods,1:len(imods),4)), 
                     axis([-2 3 -25 25]),hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
       subplot(414), plot(dat(imods,1:len(imods),1), dat(imods,1:len(imods),5)), 
                     axis([-2 3 -25 25]),hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
   end
   
   subplot(411), ylabel('$\eta_1$ (mm)', 'interpreter', 'latex', 'fontsize', 15)
   title(['BM 2:  Models ' num2str(model) ', Submergence $d =$ ' depth ' (mm)'], 'interpreter', 'latex', 'fontsize', 20)
   subplot(412), ylabel('$\eta_2$ (mm)', 'interpreter', 'latex', 'fontsize', 15)
   subplot(413), ylabel('$\eta_3$ (mm)', 'interpreter', 'latex', 'fontsize', 15)
   subplot(414), ylabel('$\eta_4$ (mm)', 'interpreter', 'latex', 'fontsize', 15)
   xlabel('$t$(s)', 'interpreter', 'latex', 'fontsize', 20),
   
   print -dpng bm2/bm2_fig1.png

%  Everything look OK?  Now, interpolate 2nd, third, etc models onto time
%  step of first model.  Reference values are determined relative to first
%  model. Replot figure 1 to make sure new times make sense.  The fit is
%  for the range -2<t<3

   
%  Truncate the time values to the range -2 < t < 3, determine
%  corresponding indices.

   N=len(1); ng = s(2)-1;
   dt=dat(1,2,1)-dat(1,1,1); tref=dat(1,1:N,1);
   tref=tref(tref<=3);  N1=length(tref); iend(1)=N1;
   tref=tref(tref>=-2); N2=length(tref); istart(1)=N1-N2+1;
   datref(:,:)=dat(1,istart(1):iend(1),2:s(2)); % datref(isnan(datref))=0; rms_error(1)=0;
   
   datsave(1,:,:)=datref;
   
   figure(2), clf
   
   subplot(411), plot(tref,datref(:,1)), 
                     axis([-2 3 -25 25]), hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
   subplot(412), plot(tref,datref(:,2)), 
                     axis([-2 3 -25 25]),hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
   subplot(413), plot(tref,datref(:,3)), 
                     axis([-2 3 -25 25]),hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
   subplot(414), plot(tref,datref(:,4)), 
                     axis([-2 3 -25 25]),hold on
                     ax=gca;
                     ax.FontSize = 15;
                     ax.FontName = 'Times';
                     
   subplot(411), ylabel('$\eta_1$ (mm)', 'interpreter', 'latex', 'fontsize', 15)
   title(['Benchmark 2: Models ' num2str(model) ', Submergence depth $d =$ ' depth ' (mm), interpolated times'], 'interpreter', 'latex', 'fontsize', 18)
   subplot(412), ylabel('$\eta_2$ (mm)', 'interpreter', 'latex', 'fontsize', 15)
   subplot(413), ylabel('$\eta_3$ (mm)', 'interpreter', 'latex', 'fontsize', 15)
   subplot(414), ylabel('$\eta_4$ (mm)', 'interpreter', 'latex', 'fontsize', 15)
   xlabel('$t$(s)', 'interpreter', 'latex', 'fontsize', 20),     
   
%  Statistics for the reference model

   etamax(1,:)=max(datref); etamin(1,:)=min(datref); etavar(1,:)=var(datref);
   
%  Repeat if there is more than one model, using the tref time axis from
%  model(1).

   
   if nmods > 1,
       
      for imods=2:nmods,
   %       
   %  construct the time and data file for model(imods) using the reference
   %  time constructed from the observed model 0 data (or whatever model is
   %  the reference).
   %
         t1=dat(imods,1:len(imods),1);
         dat1(:,:)=dat(imods,1:len(imods),2:s(2));
         dat1(isnan(dat1))=0.;
   %
   %  interpolate the data onto the reference time axis
   %
         dat1n=interp1(t1,dat1,tref); dat1n(isnan(dat1n))=0;
   %    
   %  Plot the interpolated time series
   %
         subplot(411), plot(tref,dat1n(:,1)), 
                     
         subplot(412), plot(tref,dat1n(:,2)), 
                     
         subplot(413), plot(tref,dat1n(:,3)), 
                     
         subplot(414), plot(tref,dat1n(:,4)), 
                     
      %  Statistics for mode(imods)

         etamax(imods,:)=max(dat1n), etamin(imods,:)=min(dat1n), etavar(imods,:)=var(dat1n),
         
      %  Grilli error for each gage for model(imods) relative to model(1)
      
         for ig=1:4,
             e_grilli(imods,ig) = sqrt(var(dat1n(:,ig)-datref(:,ig)))/...
                 (etamax(1,ig)-etamin(1,ig));
         end
         
         disp('e_grilli =')
         e_grilli(imods,:)
         
      %  A different global error
      
         num = sum(var( dat1n(:,ig) - datref(:,ig) ));
         den = sum(var( datref(:,ig) ) );
         e_kirby(imods) = sqrt(num/den)'
                  
         datsave(imods,:,:)=dat1n;
      
      end
   end
    
   print -dpng bm2/bm2_fig2.png
   
   % Perform a comparative wavelet analysis
   
   wavT=input('wavelet analysis? Yes=1: ');
   
   if wavT==1,
       
       %  We are going to construct the wavelet transform for each model
       %  being considered, and then we are going to look at the dominant
       %  frequencies.  
       
       %  It is good to have the data padded by a number of zeros at either
       %  end, to eliminate wrap-around.
       
       N=length(tref); ts=tref(1); te=tref(N); 
       tpad=[ ts+dt*(-floor(N/2):1:-1) tref te+dt*(1:floor(N/2))];
       
       Npad=length(tpad);
       
       for imods=1:nmods,
           
       %    imods
           
           dtemp=squeeze(datsave(imods,:,:));
           dpad=[zeros(floor(N/2),4); dtemp; zeros(floor(N/2),4)];
           
           Nd=length(dpad);
           
           for ig=1:ng,
       %        
       %   Compute wavelet transform for each model and gauge.  Note, om
       %   here is regular frequency, not angular frequency.
       %         
              x=dpad(:,ig);
              Nx = length(x);
              [T,om,tax,tridge]=wtf_f2(x,dt,model,imods,ig,bmark);
              Ntax = length(tax);
              WT(imods,ig,:,:)=T;
              tmax(imods,ig,:)=tridge;
           end
       end
    %
    %  Here, the only propagation that can be tested is the propagation from 
    %  gauge 1 to gauge 3, over the planar slope.  This willdepend on the 
    %  position of gauge 3 (fixed), the position ofgauge 1 (placed
    %  over center of slide) and the depths at each position.  We can do
    %  the integral over a very fine dx increment so that simple
    %  trapezoidal integral is accurate.
    
    %  Compute the group velocity as a function of frequency
    %
       omega=2*pi*om; g=9.80621;
       x_gauge3 = 1.929; h_gauge3=x_gauge3*0.2679;
       if depth == '061',
           x_gauge1 = 0.5338;  h_gauge1=0.143;
       else
           x_gauge1 = 0.7540;  h_gauge1=0.202;
       end
    %  
    %  Divide the intervalx_gauge3 - x_gauge1 into 100 steps,compute h and
    %  wavenumbers and group velocities at each point
    %
       dx=(x_gauge3 - x_gauge1)/99;
       x=x_gauge1 + (0:99)*dx;  h=x*0.2679;
       
       dtc=zeros(size(om));  dtcg=dtc;
       for ix = 1:length(x),
           k=wvnum_omvec(h(ix),omega,g);
           cg=(omega./(2*k)).*( 1 + (2*k*h(ix))./sinh(2*k*h(ix)) );
           c=omega./k;
           dtc = dtc + dx./c;
           dtcg = dtcg + dx./cg;
       end
       
       figure(30), clf
       
       plot(om,cg)  % c_g vs om at gauge 3
       
       tplot=tpad(1:Ntax);
    %        
    %  Compare the data and model transforms and ridge frequencies.
    %    
       v2=[tpad(1) tpad(length(tax)) 0 om(length(om))];
       t_offset=tplot(1)-tax(1);
       
       
       for ig=1:4,
           
           fignum=2+ig;
           figure(fignum), clf
           
           T1=squeeze(WT(1,ig,:,:));
        %
        %  tridge1(:,ig) saves arrival times at gauge ig as a function of
        %  frequency
           
           tridge1_tmp = squeeze(tmax(1,ig,:))+t_offset;
        %  
        %  ignore ridge values for frequencies < 0.5 Hz or > 2.5 Hz
        %
           tridge1_tmp(om<0.5) = NaN;
           tridge1_tmp(om>2.5) = NaN;
           tridge1(:,ig)=tridge1_tmp;     
           
           contour(tplot,om,abs(T1)',8), axis(v2), hold on,
           plot(squeeze(tridge1(:,ig)), om, 'r', 'Linewidth', 3)
           ax=gca;
           ax.FontSize = 15;
           ax.FontName = 'Times';
           title(['Models ' num2str(model) ', Gauge ' num2str(ig) ], 'interpreter', 'latex', 'fontsize', 20)
           xlabel('$t$(s)', 'interpreter', 'latex', 'fontsize', 20),
           ylabel('$f$ (Hz)', 'interpreter', 'latex', 'fontsize', 20),
           
           if nmods>1,
               for imods = 2:nmods,
                   T2=squeeze(WT(imods,ig,:,:)); 
                   
                   tridge2_tmp=squeeze(tmax(imods,ig,:))+t_offset;
                   tridge2_tmp(om<0.5) = NaN;
                   tridge2_tmp(om>2.5) = NaN;
                %  
                %  tridge2(:,ig,imods) saves the calculated arrival times
                %  for each of the models being tested
                %
                   tridge2(:,ig,imods-1)=tridge2_tmp;
                   
                   
                   contour(tplot,om,abs(T2)',8, '--');
                   plot(squeeze(tridge2(:,ig,imods-1)), om, 'b', 'Linewidth', 3)
               end
           end
          
        %
        %  Now, calculate the theoretical arrival time st gauge 3 based on the actual
        %  group (or phase) velocity, starting from the measured data at gauge 1
        
           if ig == 3, 
               tridge3 = squeeze( tridge1(:,1) ) + dtcg';
               tridge4 = squeeze( tridge1(:,1) ) + dtc';
               plot(tridge3, om, 'r--', tridge4, om, 'r:', 'Linewidth', 3)  
           end
        %
        %  Print results
        %      
           eval(['print -dpng bm2/bm2_fig' num2str(fignum) '.png'])
       end     
   end
 




